/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.jsp.compiler.internal;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.servlet.jsp.compiler.internal.BaseJavaFileObject;
import com.liferay.portal.servlet.jsp.compiler.internal.JavaFileObjectResolver;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.felix.utils.log.Logger;

public class BundleJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    public static final String OPT_VERBOSE = "-verbose";
    private static final Set<JavaFileObject.Kind> _kinds = EnumSet.of(JavaFileObject.Kind.CLASS);
    private static final Field _nameField;
    private static final Class<?> _zipFileIndexFileObjectClass;
    private final ClassLoader _classLoader;
    private final JavaFileObjectResolver _javaFileObjectResolver;
    private final Logger _logger;
    private final Set<String> _systemPackageNames;
    private final boolean _verbose;

    public BundleJavaFileManager(ClassLoader classLoader, Set<String> systemPackageNames, JavaFileManager javaFileManager, Logger logger, boolean verbose, JavaFileObjectResolver javaFileObjectResolver) {
        super(javaFileManager);
        this._classLoader = classLoader;
        this._systemPackageNames = systemPackageNames;
        this._logger = logger;
        this._verbose = verbose;
        this._javaFileObjectResolver = javaFileObjectResolver;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (location != StandardLocation.CLASS_PATH) {
            return this.fileManager.getClassLoader(location);
        }
        return this._classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == StandardLocation.CLASS_PATH && file instanceof BaseJavaFileObject) {
            BaseJavaFileObject baseJavaFileObject = (BaseJavaFileObject)file;
            if (this._verbose) {
                this._logger.log(3, "Inferring binary name from " + baseJavaFileObject);
            }
            return baseJavaFileObject.getClassName();
        }
        if (file.getClass() == _zipFileIndexFileObjectClass) {
            try {
                String name = (String)_nameField.get(file);
                return name.substring(0, name.lastIndexOf(46));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this.fileManager.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Collection<JavaFileObject> javaFileObjects;
        if (!kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            return Collections.emptyList();
        }
        if (location == StandardLocation.CLASS_PATH && this._verbose) {
            StringBundler sb = new StringBundler(9);
            sb.append("List for {kinds=");
            sb.append(_kinds);
            sb.append(", location=");
            sb.append((Object)location);
            sb.append(", packageName=");
            sb.append(packageName);
            sb.append(", recurse=");
            sb.append(recurse);
            sb.append("}");
            this._logger.log(3, sb.toString());
        }
        String packagePath = packageName.replace('.', '/');
        if (!(packageName.startsWith("java.") || location != StandardLocation.CLASS_PATH || (javaFileObjects = this._javaFileObjectResolver.resolveClasses(recurse, packagePath)).isEmpty() && this._systemPackageNames.contains(packageName))) {
            return javaFileObjects;
        }
        return this.fileManager.list(location, packagePath, _kinds, recurse);
    }

    static {
        Field nameField = null;
        Class<?> zipFileIndexFileObjectClass = null;
        if ((JavaDetector.isOpenJDK() || JavaDetector.isOracle()) && GetterUtil.getBoolean((String)SystemProperties.get((String)"portal.servlet.jsp.compiler.sun.javac.hack.enabled"), (boolean)true)) {
            try {
                ClassLoader systemToolClassLoader = ToolProvider.getSystemToolClassLoader();
                zipFileIndexFileObjectClass = systemToolClassLoader.loadClass("com.sun.tools.javac.file.ZipFileIndexArchive$ZipFileIndexFileObject");
                nameField = zipFileIndexFileObjectClass.getDeclaredField("name");
                nameField.setAccessible(true);
            }
            catch (ReflectiveOperationException roe) {
                nameField = null;
                zipFileIndexFileObjectClass = null;
            }
        }
        _zipFileIndexFileObjectClass = zipFileIndexFileObjectClass;
        _nameField = nameField;
    }
}

