<%--
/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */
--%>

<%@ include file="/dynamic_include/init.jsp" %>

<%
ConfigurationProvider<LDAPExportConfiguration> ldapExportConfigurationProvider = ConfigurationProviderUtil.getLDAPExportConfigurationProvider();

LDAPExportConfiguration ldapExportConfiguration = ldapExportConfigurationProvider.getConfiguration(themeDisplay.getCompanyId());

ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider = ConfigurationProviderUtil.getLDAPImportConfigurationProvider();

LDAPImportConfiguration ldapImportConfiguration = ldapImportConfigurationProvider.getConfiguration(themeDisplay.getCompanyId());

boolean ldapImportEnabled = ldapImportConfiguration.importEnabled();
%>

<aui:fieldset>
	<aui:input name="<%= Constants.CMD %>" type="hidden" value="<%= LDAPSettingsConstants.CMD_UPDATE_EXPORT %>" />

	<aui:input disabled="<%= ldapImportConfiguration.importUserPasswordAutogenerated() && ldapImportEnabled %>" id="ldapExportEnabled" label="enable-export" name='<%= "ldap--" + LDAPConstants.EXPORT_ENABLED + "--" %>' type="checkbox" value="<%= !(ldapImportConfiguration.importUserPasswordAutogenerated() && ldapImportEnabled) && ldapExportConfiguration.exportEnabled() %>" />

	<aui:input id="ldapExportGroupEnabled" label="enable-group-export" name='<%= "ldap--" + LDAPConstants.EXPORT_GROUP_ENABLED + "--" %>' type="checkbox" value="<%= ldapExportConfiguration.exportGroupEnabled() %>" />
</aui:fieldset>