/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBContext;
import com.liferay.portal.kernel.dao.db.DBManager;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.internal.configuration.ConfigurationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import javax.sql.DataSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class InitialUpgradeExtender
implements BundleTrackerCustomizer<ServiceRegistration<?>> {
    private static final Log _log = LogFactoryUtil.getLog(InitialUpgradeExtender.class);
    private BundleContext _bundleContext;
    private BundleTracker<?> _bundleTracker;
    @Reference(target="(&(bean.id=liferayDataSource)(original.bean=true))")
    private DataSource _dataSource;

    public ServiceRegistration<?> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Dictionary headers = bundle.getHeaders("");
        if (headers.get("Liferay-Service") == null) {
            return null;
        }
        return this._processInitialUpgrade(this._bundleContext, bundle, this._dataSource);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceRegistration<?> serviceRegistration) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceRegistration<?> serviceRegistration) {
        serviceRegistration.unregister();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private ServiceRegistration<UpgradeStep> _processInitialUpgrade(BundleContext bundleContext, Bundle bundle, DataSource dataSource) {
        String buildNumber;
        HashMapDictionary properties = new HashMapDictionary();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        Configuration configuration = ConfigurationUtil.getConfiguration(bundleWiring.getClassLoader(), "service");
        if (configuration != null && (buildNumber = configuration.get("build.number")) != null) {
            properties.put("build.number", buildNumber);
        }
        properties.put("upgrade.initial.database.creation", "true");
        properties.put("upgrade.bundle.symbolic.name", bundle.getSymbolicName());
        properties.put("upgrade.db.type", "any");
        properties.put("upgrade.from.schema.version", "0.0.0");
        Dictionary headers = bundle.getHeaders("");
        String upgradeToSchemaVersion = GetterUtil.getString((String)((String)headers.get("Liferay-Require-SchemaVersion")), (String)((String)headers.get("Bundle-Version")));
        properties.put("upgrade.to.schema.version", upgradeToSchemaVersion);
        return bundleContext.registerService(UpgradeStep.class, (Object)new InitialUpgradeStep(bundle, dataSource), (Dictionary)properties);
    }

    private static class InitialUpgradeStep
    implements UpgradeStep {
        private final Bundle _bundle;
        private final DataSource _dataSource;
        private DB _db;

        public String toString() {
            return "Initial Database Creation";
        }

        public void upgrade(DBProcessContext dbProcessContext) throws UpgradeException {
            DBContext dbContext = dbProcessContext.getDBContext();
            DBManager dbManager = dbContext.getDBManager();
            this._db = dbManager.getDB();
            try {
                this._db.process(companyId -> {
                    if (_log.isInfoEnabled() && Validator.isNotNull((Long)companyId)) {
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{this.toString(), " ", this._bundle.getSymbolicName(), "#", companyId}));
                    }
                    this._upgrade();
                });
            }
            catch (Exception exception) {
                new UpgradeException((Throwable)exception);
            }
        }

        private InitialUpgradeStep(Bundle bundle, DataSource dataSource) {
            this._bundle = bundle;
            this._dataSource = dataSource;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String _getSQLTemplateString(String templateName) throws UpgradeException {
            URL resource = this._bundle.getResource("/META-INF/sql/" + templateName);
            if (resource == null) {
                if (!_log.isDebugEnabled()) return null;
                _log.debug((Object)("Unable to locate SQL template " + templateName));
                return null;
            }
            try (InputStream inputStream = resource.openStream();){
                String string = StringUtil.read((InputStream)inputStream);
                return string;
            }
            catch (IOException ioException) {
                throw new UpgradeException("Unable to read SQL template " + templateName, (Throwable)ioException);
            }
        }

        private void _upgrade() throws UpgradeException {
            block22: {
                String tablesSQL = this._getSQLTemplateString("tables.sql");
                String sequencesSQL = this._getSQLTemplateString("sequences.sql");
                String indexesSQL = this._getSQLTemplateString("indexes.sql");
                try (Connection connection = this._dataSource.getConnection();){
                    if (tablesSQL != null) {
                        try {
                            this._db.runSQLTemplateString(connection, tablesSQL, true);
                        }
                        catch (Exception exception) {
                            throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in tables.sql:\n", tablesSQL}), (Throwable)exception);
                        }
                    }
                    if (sequencesSQL != null) {
                        try {
                            this._db.runSQLTemplateString(connection, sequencesSQL, true);
                        }
                        catch (Exception exception) {
                            throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in sequences.sql:\n", sequencesSQL}), (Throwable)exception);
                        }
                    }
                    if (indexesSQL == null) break block22;
                    try {
                        this._db.runSQLTemplateString(connection, indexesSQL, true);
                    }
                    catch (Exception exception) {
                        throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in indexes.sql:\n", indexesSQL}), (Throwable)exception);
                    }
                }
                catch (SQLException sqlException) {
                    throw new UpgradeException((Throwable)sqlException);
                }
            }
        }
    }
}

