/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.dao.orm.hibernate.SessionFactoryImpl;
import com.liferay.portal.dao.orm.hibernate.VerifySessionFactoryWrapper;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.SystemExecutorServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.spring.extender.internal.jdbc.DataSourceUtil;
import com.liferay.portal.spring.extender.internal.loader.ModuleAggregareClassLoader;
import com.liferay.portal.spring.extender.internal.upgrade.release.SchemaCreatorImpl;
import com.liferay.portal.spring.hibernate.PortalTransactionManager;
import com.liferay.portal.spring.hibernate.PortletHibernateConfiguration;
import com.liferay.portal.spring.hibernate.PortletTransactionManager;
import com.liferay.portal.spring.transaction.DefaultTransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionManagerFactory;
import com.liferay.portal.upgrade.release.SchemaCreator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.springframework.transaction.PlatformTransactionManager;

@Component(service={})
public class LiferayServiceExtender
implements BundleTrackerCustomizer<Supplier<LiferayServiceExtension>> {
    private static final Log _log = LogFactoryUtil.getLog(LiferayServiceExtender.class);
    private BundleTracker<Supplier<LiferayServiceExtension>> _bundleTracker;

    public Supplier<LiferayServiceExtension> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Dictionary headers = bundle.getHeaders("");
        if (headers.get("Liferay-Service") == null || headers.get("Liferay-Spring-Context") != null) {
            return null;
        }
        ExecutorService executorService = SystemExecutorServiceUtil.getExecutorService();
        DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture(() -> {
            LiferayServiceExtension liferayServiceExtension = new LiferayServiceExtension(bundle);
            liferayServiceExtension.start();
            return liferayServiceExtension;
        });
        executorService.submit((Runnable)defaultNoticeableFuture);
        return () -> {
            try {
                return (LiferayServiceExtension)defaultNoticeableFuture.get();
            }
            catch (InterruptedException interruptedException) {
                _log.error((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                _log.error(executionException.getCause());
            }
            return null;
        };
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Supplier<LiferayServiceExtension> supplier) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Supplier<LiferayServiceExtension> supplier) {
        LiferayServiceExtension liferayServiceExtension = supplier.get();
        if (liferayServiceExtension != null) {
            liferayServiceExtension.destroy();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        DependencyManagerSyncUtil.registerSyncFutureTask(new FutureTask<Object>(() -> {
            this._bundleTracker.open();
            Map map = this._bundleTracker.getTracked();
            for (Supplier supplier : map.values()) {
                supplier.get();
            }
            return null;
        }), (String)(LiferayServiceExtender.class.getName() + "-BundleTrackerOpener"));
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    public class LiferayServiceExtension {
        private DataSource _dataSource;
        private final Bundle _extendeeBundle;
        private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();
        private final DCLSingleton<SessionFactoryImplementor> _sessionFactoryImplementorDCLSingleton = new DCLSingleton();

        public void destroy() {
            for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
                serviceRegistration.unregister();
            }
            this._sessionFactoryImplementorDCLSingleton.destroy(SessionFactory::close);
            if (InfrastructureUtil.getDataSource() != this._dataSource) {
                try {
                    DataSourceFactoryUtil.destroyDataSource((DataSource)this._dataSource);
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to destroy external data source " + this._dataSource), (Throwable)exception);
                }
            }
        }

        public void start() throws Exception {
            BundleWiring extendeeBundleWiring = (BundleWiring)this._extendeeBundle.adapt(BundleWiring.class);
            ClassLoader extendeeClassLoader = extendeeBundleWiring.getClassLoader();
            this._dataSource = DataSourceUtil.getDataSource(extendeeClassLoader);
            BundleContext extendeeBundleContext = this._extendeeBundle.getBundleContext();
            this._serviceRegistrations.add(extendeeBundleContext.registerService(SchemaCreator.class, (Object)new SchemaCreatorImpl(this._extendeeBundle, this._dataSource), null));
            ModuleAggregareClassLoader classLoader = new ModuleAggregareClassLoader(extendeeClassLoader, this._extendeeBundle.getSymbolicName());
            Supplier<SessionFactoryImplementor> sessionFactoryImplementorSupplier = () -> (SessionFactoryImplementor)this._sessionFactoryImplementorDCLSingleton.getSingleton(() -> {
                PortletHibernateConfiguration portletHibernateConfiguration = new PortletHibernateConfiguration(classLoader, this._dataSource);
                try {
                    portletHibernateConfiguration.afterPropertiesSet();
                }
                catch (IOException ioException) {
                    ReflectionUtil.throwException((Throwable)ioException);
                }
                return (SessionFactoryImplementor)portletHibernateConfiguration.getObject();
            });
            DefaultTransactionExecutor defaultTransactionExecutor = this._getTransactionExecutor(this._dataSource, sessionFactoryImplementorSupplier);
            this._serviceRegistrations.add(extendeeBundleContext.registerService(TransactionExecutor.class, (Object)defaultTransactionExecutor, MapUtil.singletonDictionary((Object)"origin.bundle.symbolic.name", (Object)this._extendeeBundle.getSymbolicName())));
            this._serviceRegistrations.add(extendeeBundleContext.registerService(DataSource.class, (Object)this._dataSource, MapUtil.singletonDictionary((Object)"origin.bundle.symbolic.name", (Object)this._extendeeBundle.getSymbolicName())));
            SessionFactoryImpl sessionFactoryImpl = new SessionFactoryImpl();
            sessionFactoryImpl.setSessionFactoryClassLoader((ClassLoader)classLoader);
            sessionFactoryImpl.setSessionFactoryImplementorSupplier(sessionFactoryImplementorSupplier);
            com.liferay.portal.kernel.dao.orm.SessionFactory sessionFactory = VerifySessionFactoryWrapper.createVerifySessionFactoryWrapper((SessionFactoryImpl)sessionFactoryImpl);
            this._serviceRegistrations.add(extendeeBundleContext.registerService(com.liferay.portal.kernel.dao.orm.SessionFactory.class, (Object)sessionFactory, MapUtil.singletonDictionary((Object)"origin.bundle.symbolic.name", (Object)this._extendeeBundle.getSymbolicName())));
        }

        private LiferayServiceExtension(Bundle extendeeBundle) {
            this._extendeeBundle = extendeeBundle;
        }

        private DefaultTransactionExecutor _getTransactionExecutor(DataSource liferayDataSource, Supplier<SessionFactoryImplementor> sessionFactoryImplementorSupplier) {
            Object platformTransactionManager = null;
            platformTransactionManager = InfrastructureUtil.getDataSource() == liferayDataSource ? new PortletTransactionManager((PortalTransactionManager)InfrastructureUtil.getTransactionManager(), sessionFactoryImplementorSupplier) : TransactionManagerFactory.createTransactionManager((DataSource)liferayDataSource, (SessionFactory)((SessionFactory)sessionFactoryImplementorSupplier.get()));
            return new DefaultTransactionExecutor((PlatformTransactionManager)platformTransactionManager);
        }
    }
}

