/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.configuration;

import com.liferay.petra.io.Deserializer;
import com.liferay.petra.io.Serializer;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.BundleUtil;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={})
public class PortletConfigurationExtender
implements BundleTrackerCustomizer<ServiceRegistration<Configuration>> {
    private static final Log _log = LogFactoryUtil.getLog(PortletConfigurationExtender.class);
    private BundleContext _bundleContext;
    private BundleTracker<?> _bundleTracker;
    private final Map<String, Long> _refreshedURLTimestamps = new HashMap<String, Long>();
    @Reference
    private ResourceActions _resourceActions;
    private Map<String, Long> _urlTimestamps;

    public ServiceRegistration<Configuration> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        if (!BundleUtil.isLiferayServiceBundle((Bundle)bundle)) {
            return null;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        Configuration portletConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
        if (portletConfiguration == null) {
            return null;
        }
        try {
            String[] resourceActionsConfigurations = StringUtil.split((String)portletConfiguration.get("resource.actions.configs"));
            boolean checkResourceActions = !this._isUpToDate(classLoader, resourceActionsConfigurations);
            this._resourceActions.populateModelResources(classLoader, resourceActionsConfigurations, checkResourceActions);
            if (!PropsValues.RESOURCE_ACTIONS_STRICT_MODE_ENABLED) {
                this._resourceActions.populatePortletResources(classLoader, resourceActionsConfigurations, checkResourceActions);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to read resource actions config in resource.actions.configs", (Throwable)exception);
        }
        return this._bundleContext.registerService(Configuration.class, (Object)portletConfiguration, (Dictionary)HashMapDictionaryBuilder.put((Object)"name", (Object)"portlet").put((Object)"origin.bundle.symbolic.name", (Object)bundle.getSymbolicName()).build());
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceRegistration<Configuration> serviceRegistration) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceRegistration<Configuration> serviceRegistration) {
        serviceRegistration.unregister();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._urlTimestamps = this._loadURLTimestamps(bundleContext);
        this._bundleContext = bundleContext;
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
        this._saveURLTimestamps(this._bundleContext, this._refreshedURLTimestamps);
    }

    private void _enqueue(Queue<String> queue, String resourceActionsConfiguration) {
        queue.add(resourceActionsConfiguration);
        if (!resourceActionsConfiguration.endsWith("-ext.xml")) {
            queue.add(StringUtil.replace((String)resourceActionsConfiguration, (String)".xml", (String)"-ext.xml"));
        }
    }

    private boolean _isUpToDate(ClassLoader classLoader, String[] resourceActionsConfigurations) throws Exception {
        Map<URL, Long> urlTimestamps = this._toURLTimestamps(classLoader, resourceActionsConfigurations);
        boolean upToDate = true;
        for (Map.Entry<URL, Long> entry : urlTimestamps.entrySet()) {
            URL url = entry.getKey();
            String urlString = this._trimFwkHash(url.toExternalForm());
            Long cachedLastModifiedTime = this._urlTimestamps.get(urlString);
            if (cachedLastModifiedTime == null || !cachedLastModifiedTime.equals(entry.getValue())) {
                upToDate = false;
            }
            this._refreshedURLTimestamps.put(urlString, entry.getValue());
        }
        return upToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Long> _loadURLTimestamps(BundleContext bundleContext) {
        HashMap<String, Long> urlTimestamps = new HashMap<String, Long>();
        File dataFile = bundleContext.getDataFile("urlTimestamps.data");
        if (dataFile.exists() && !StartupHelperUtil.isDBNew() && !StartupHelperUtil.isUpgrading()) {
            try {
                Deserializer deserializer = new Deserializer(ByteBuffer.wrap(FileUtil.getBytes((File)dataFile)));
                Bundle bundle = bundleContext.getBundle();
                if (deserializer.readBoolean() != PropsValues.RESOURCE_ACTIONS_STRICT_MODE_ENABLED || deserializer.readLong() != bundle.getLastModified()) return urlTimestamps;
                int size = deserializer.readInt();
                for (int i = 0; i < size; ++i) {
                    urlTimestamps.put(deserializer.readString(), deserializer.readLong());
                }
                return urlTimestamps;
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) return urlTimestamps;
                _log.warn((Object)"Unable to load url timestamps data", (Throwable)exception);
                return urlTimestamps;
            }
        } else {
            dataFile.delete();
        }
        return urlTimestamps;
    }

    private void _saveURLTimestamps(BundleContext bundleContext, Map<String, Long> urlTimestamps) {
        block8: {
            Bundle bundle = bundleContext.getBundle();
            Serializer serializer = new Serializer();
            serializer.writeBoolean(PropsValues.RESOURCE_ACTIONS_STRICT_MODE_ENABLED);
            serializer.writeLong(bundle.getLastModified());
            serializer.writeInt(urlTimestamps.size());
            for (Map.Entry<String, Long> entry : urlTimestamps.entrySet()) {
                serializer.writeString(entry.getKey());
                serializer.writeLong(entry.getValue().longValue());
            }
            File dataFile = bundleContext.getDataFile("urlTimestamps.data");
            try (FileOutputStream outputStream = new FileOutputStream(dataFile);){
                serializer.writeTo((OutputStream)outputStream);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)"Unable to write url timestamps data", (Throwable)exception);
            }
        }
    }

    private Map<URL, Long> _toURLTimestamps(ClassLoader classLoader, String[] resourceActionsConfigurations) throws Exception {
        HashMap<URL, Long> urlTimestamps = new HashMap<URL, Long>();
        LinkedList<String> queue = new LinkedList<String>();
        for (String resourceActionsConfiguration : resourceActionsConfigurations) {
            this._enqueue(queue, resourceActionsConfiguration);
        }
        String resourceActionsConfiguration = null;
        while ((resourceActionsConfiguration = (String)queue.poll()) != null) {
            URL url = classLoader.getResource(resourceActionsConfiguration);
            if (url == null) continue;
            URLConnection urlConnection = url.openConnection();
            urlTimestamps.put(url, urlConnection.getLastModified());
            InputStream inputStream = urlConnection.getInputStream();
            try {
                String content = StreamUtil.toString((InputStream)inputStream);
                if (!content.contains("<resource ")) continue;
                Document document = UnsecureSAXReaderUtil.read((String)content, (boolean)true);
                Element rootElement = document.getRootElement();
                for (Element resourceElement : rootElement.elements("resource")) {
                    this._enqueue(queue, StringUtil.trim((String)resourceElement.attributeValue("file")));
                }
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return urlTimestamps;
    }

    private String _trimFwkHash(String urlString) {
        int endIndex;
        int startIndex = urlString.indexOf(".fwk");
        if (startIndex != -1 && (endIndex = urlString.indexOf(47, startIndex + 4)) != -1) {
            String head = urlString.substring(0, startIndex);
            return head.concat(urlString.substring(endIndex));
        }
        return urlString;
    }
}

