/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.configuration;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.spring.extender.internal.configuration.ServiceConfigurationInitializer;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={})
public class ServiceConfigurationExtender
implements BundleTrackerCustomizer<ServiceConfigurationInitializer> {
    private static final Log _log = LogFactoryUtil.getLog(ServiceConfigurationExtender.class);
    private BundleTracker<?> _bundleTracker;
    @Reference
    private ServiceComponentLocalService _serviceComponentLocalService;

    public ServiceConfigurationInitializer addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        String versionRangeFilter;
        Configuration serviceConfiguration;
        ClassLoader classLoader;
        block8: {
            Dictionary headers = bundle.getHeaders("");
            if (headers.get("Liferay-Service") == null) {
                return null;
            }
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            classLoader = bundleWiring.getClassLoader();
            serviceConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
            if (serviceConfiguration == null) {
                return null;
            }
            String requireSchemaVersion = (String)headers.get("Liferay-Require-SchemaVersion");
            if (requireSchemaVersion == null) {
                _log.error((Object)"Liferay-Require-SchemaVersion is required");
                return null;
            }
            versionRangeFilter = null;
            try {
                Version version = new Version(requireSchemaVersion);
                versionRangeFilter = this._getVersionRangerFilter(version);
            }
            catch (IllegalArgumentException illegalArgumentException1) {
                try {
                    VersionRange versionRange = new VersionRange(requireSchemaVersion);
                    versionRangeFilter = versionRange.toFilterString("release.schema.version");
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    illegalArgumentException1.addSuppressed(illegalArgumentException2);
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)("Invalid \"Liferay-Require-SchemaVersion\" header for bundle: " + bundle.getBundleId()), (Throwable)illegalArgumentException1);
                }
            }
        }
        if (versionRangeFilter == null) {
            return null;
        }
        ServiceConfigurationInitializer serviceConfigurationInitializer = new ServiceConfigurationInitializer(bundle, classLoader, serviceConfiguration, this._serviceComponentLocalService);
        ServiceLatch serviceLatch = new ServiceLatch(bundle.getBundleContext());
        serviceLatch.waitFor(StringBundler.concat((String[])new String[]{"(&(objectClass=", Release.class.getName(), ")(release.bundle.symbolic.name=", bundle.getSymbolicName(), ")", versionRangeFilter, ")"}));
        serviceLatch.openOn(serviceConfigurationInitializer::start);
        return serviceConfigurationInitializer;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceConfigurationInitializer serviceConfigurationInitializer) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ServiceConfigurationInitializer serviceConfigurationInitializer) {
        serviceConfigurationInitializer.stop();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private String _getVersionRangerFilter(Version version) {
        return StringBundler.concat((Object[])new Object[]{"(&(release.schema.version>=", version.getMajor(), ".", version.getMinor(), ".0)(!(release.schema.version>=", version.getMajor() + 1, ".0.0)))"});
    }
}

