/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.configuration;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.service.configuration.ServiceComponentConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.DBUpgrader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.FutureTask;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ServiceConfigurationInitializer {
    private static final Log _log = LogFactoryUtil.getLog(ServiceConfigurationInitializer.class);
    private final Bundle _bundle;
    private final ClassLoader _classLoader;
    private final FutureTask<Closeable> _futureTask;
    private final ServiceComponentConfiguration _serviceComponentConfiguration = new ModuleResourceLoader();
    private final ServiceComponentLocalService _serviceComponentLocalService;
    private final Configuration _serviceConfiguration;

    public ServiceConfigurationInitializer(Bundle bundle, ClassLoader classLoader, Configuration serviceConfiguration, ServiceComponentLocalService serviceComponentLocalService) {
        this._bundle = bundle;
        this._classLoader = classLoader;
        this._serviceConfiguration = serviceConfiguration;
        this._serviceComponentLocalService = serviceComponentLocalService;
        this._futureTask = new FutureTask<Closeable>(() -> {
            this._initServiceComponent();
            BundleContext bundleContext = bundle.getBundleContext();
            ServiceRegistration serviceRegistration = bundleContext.registerService(Configuration.class, (Object)this._serviceConfiguration, (Dictionary)HashMapDictionaryBuilder.put((Object)"name", (Object)"service").put((Object)"origin.bundle.symbolic.name", (Object)bundle.getSymbolicName()).build());
            return () -> ((ServiceRegistration)serviceRegistration).unregister();
        });
    }

    public void stop() {
        try {
            Closeable closeable = this._futureTask.get();
            closeable.close();
        }
        catch (Exception exception) {
            ReflectionUtil.throwException((Throwable)exception);
        }
    }

    protected void start() {
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"dependency.manager.thread.pool.enabled"), (boolean)true) && !DBUpgrader.isUpgradeDatabaseAutoRunEnabled()) {
            DependencyManagerSyncUtil.registerSyncFutureTask(this._futureTask, (String)(ServiceConfigurationInitializer.class.getName() + "-" + this._bundle.getSymbolicName()));
        } else {
            this._futureTask.run();
        }
    }

    private void _initServiceComponent() {
        Properties properties = this._serviceConfiguration.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        String buildNamespace = GetterUtil.getString((String)properties.getProperty("build.namespace"));
        long buildNumber = GetterUtil.getLong((String)properties.getProperty("build.number"));
        long buildDate = GetterUtil.getLong((String)properties.getProperty("build.date"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build namespace " + buildNamespace));
            _log.debug((Object)("Build number " + buildNumber));
            _log.debug((Object)("Build date " + buildDate));
        }
        if (Validator.isNull((String)buildNamespace)) {
            return;
        }
        try {
            this._serviceComponentLocalService.initServiceComponent(this._serviceComponentConfiguration, this._classLoader, buildNamespace, buildNumber, buildDate);
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to initialize service component", (Throwable)portalException);
        }
    }

    private class ModuleResourceLoader
    implements ServiceComponentConfiguration {
        private ModuleResourceLoader() {
        }

        public InputStream getHibernateInputStream() {
            return this._getInputStream("/META-INF/module-hbm.xml");
        }

        public InputStream getModelHintsExtInputStream() {
            return this._getInputStream("/META-INF/portlet-model-hints-ext.xml");
        }

        public InputStream getModelHintsInputStream() {
            return this._getInputStream("/META-INF/portlet-model-hints.xml");
        }

        public String getServletContextName() {
            return ServiceConfigurationInitializer.this._bundle.getSymbolicName();
        }

        public InputStream getSQLIndexesInputStream() {
            return this._getInputStream("/META-INF/sql/indexes.sql");
        }

        public InputStream getSQLSequencesInputStream() {
            return this._getInputStream("/META-INF/sql/sequences.sql");
        }

        public InputStream getSQLTablesInputStream() {
            return this._getInputStream("/META-INF/sql/tables.sql");
        }

        private InputStream _getInputStream(String location) {
            URL url = ServiceConfigurationInitializer.this._bundle.getResource(location);
            if (url == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to find " + location));
                }
                return null;
            }
            InputStream inputStream = null;
            try {
                inputStream = url.openStream();
            }
            catch (IOException ioException) {
                _log.error((Object)("Unable to read " + location), (Throwable)ioException);
            }
            return inputStream;
        }
    }
}

