/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.context;

import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.spring.extender.internal.jdbc.DataSourceUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ModuleApplicationContext
extends ClassPathXmlApplicationContext {
    protected final Bundle bundle;
    private volatile DataSource _dataSource;
    private final AtomicBoolean _freshBeanFactory = new AtomicBoolean(true);

    public static void registerDataSourceBean(ConfigurableListableBeanFactory configurableListableBeanFactory, ClassLoader extendeeClassLoader) {
        if (configurableListableBeanFactory.containsBean("liferayDataSource")) {
            return;
        }
        DataSource dataSource = DataSourceUtil.getDataSource(extendeeClassLoader);
        configurableListableBeanFactory.registerSingleton("liferayDataSource", (Object)dataSource);
        if (InfrastructureUtil.getDataSource() != dataSource) {
            DefaultSingletonBeanRegistry defaultSingletonBeanRegistry = (DefaultSingletonBeanRegistry)configurableListableBeanFactory;
            defaultSingletonBeanRegistry.registerDisposableBean("dataSourceDestroyer", () -> DataSourceFactoryUtil.destroyDataSource((DataSource)dataSource));
        }
    }

    public ModuleApplicationContext(Bundle bundle, ClassLoader extendeeClassLoader, ClassLoader resourceLoaderClassLoader, String[] configLocations) {
        super(configLocations, false, null);
        this.bundle = bundle;
        this.setClassLoader(resourceLoaderClassLoader);
        super.refreshBeanFactory();
        ConfigurableListableBeanFactory configurableListableBeanFactory = this.getBeanFactory();
        ModuleApplicationContext.registerDataSourceBean(configurableListableBeanFactory, extendeeClassLoader);
        this._dataSource = (DataSource)configurableListableBeanFactory.getBean("liferayDataSource", DataSource.class);
    }

    public BundleContext getBundleContext() {
        return this.bundle.getBundleContext();
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public Resource[] getResources(String locationPattern) {
        Enumeration enumeration = this.bundle.findEntries(locationPattern, "*.xml", true);
        ArrayList<UrlResource> resources = new ArrayList<UrlResource>();
        while (enumeration.hasMoreElements()) {
            resources.add(new UrlResource((URL)enumeration.nextElement()));
        }
        return resources.toArray(new Resource[0]);
    }

    public void refresh() throws BeansException, IllegalStateException {
        super.refresh();
        this._dataSource = (DataSource)this.getBean("liferayDataSource", DataSource.class);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new DefaultListableBeanFactory(this.getInternalParentBeanFactory()){

            protected Object getEarlyBeanReference(String beanName, RootBeanDefinition rootBeanDefinition, Object bean) {
                if (bean == null || rootBeanDefinition.isSynthetic()) {
                    return bean;
                }
                Object exposedObject = bean;
                for (BeanPostProcessor beanPostProcessor : this.getBeanPostProcessors()) {
                    SmartInstantiationAwareBeanPostProcessor smartInstantiationAwareBeanPostProcessor;
                    if (!(beanPostProcessor instanceof SmartInstantiationAwareBeanPostProcessor) || (exposedObject = (smartInstantiationAwareBeanPostProcessor = (SmartInstantiationAwareBeanPostProcessor)beanPostProcessor).getEarlyBeanReference(exposedObject, beanName)) != null) continue;
                    return exposedObject;
                }
                return exposedObject;
            }

            protected boolean hasInstantiationAwareBeanPostProcessors() {
                return false;
            }
        };
    }

    protected ConfigurableListableBeanFactory obtainFreshBeanFactory() {
        if (this._freshBeanFactory.compareAndSet(true, false)) {
            return this.getBeanFactory();
        }
        return super.obtainFreshBeanFactory();
    }
}

