/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.loader;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;

public class ModuleAggregareClassLoader
extends ClassLoader {
    private static final Method _FIND_CLASS_METHOD;
    private static final Log _log;
    private static final ClassLoader _extenderClassLoader;
    private final ClassLoader _moduleClassLoader;
    private final String _namespace;

    public ModuleAggregareClassLoader(ClassLoader moduleClassLoader, String symbolicName) {
        super(null);
        this._moduleClassLoader = moduleClassLoader;
        int index = symbolicName.lastIndexOf(46);
        this._namespace = index == -1 ? symbolicName : symbolicName.substring(0, index);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ModuleAggregareClassLoader)) {
            return false;
        }
        ModuleAggregareClassLoader moduleAggregareClassLoader = (ModuleAggregareClassLoader)object;
        return Objects.equals(this._moduleClassLoader, moduleAggregareClassLoader._moduleClassLoader);
    }

    @Override
    public URL getResource(String name) {
        URL url = this._moduleClassLoader.getResource(name);
        if (url != null) {
            return url;
        }
        return _extenderClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.addAll(Collections.list(this._moduleClassLoader.getResources(name)));
        urls.addAll(Collections.list(_extenderClassLoader.getResources(name)));
        return Collections.enumeration(urls);
    }

    public int hashCode() {
        return this._moduleClassLoader.hashCode();
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith(this._namespace)) {
            return this._moduleClassLoader.loadClass(name);
        }
        try {
            return _extenderClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)classNotFoundException);
            }
            return this._moduleClassLoader.loadClass(name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return (Class)_FIND_CLASS_METHOD.invoke((Object)this._moduleClassLoader, name);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ClassNotFoundException("Unable to find class " + name, invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Unable to find class " + name, exception);
        }
    }

    static {
        _log = LogFactoryUtil.getLog(ModuleAggregareClassLoader.class);
        _extenderClassLoader = ModuleAggregareClassLoader.class.getClassLoader();
        try {
            _FIND_CLASS_METHOD = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"findClass", (Class[])new Class[]{String.class});
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

