/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.upgrade.release;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.DBResourceUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.upgrade.release.SchemaCreator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import javax.sql.DataSource;
import org.osgi.framework.Bundle;

public class SchemaCreatorImpl
implements SchemaCreator {
    private static final Log _log = LogFactoryUtil.getLog(SchemaCreatorImpl.class);
    private final Bundle _bundle;
    private final DataSource _dataSource;
    private DB _db;

    public SchemaCreatorImpl(Bundle bundle, DataSource dataSource) {
        this._bundle = bundle;
        this._dataSource = dataSource;
    }

    public void create() throws UpgradeException {
        this._db = DBManagerUtil.getDB((Object)DialectDetector.getDialect((DataSource)this._dataSource), (DataSource)this._dataSource);
        try {
            this._db.process(companyId -> {
                if (_log.isInfoEnabled() && Validator.isNotNull((Long)companyId)) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{this.toString(), " ", this._bundle.getSymbolicName(), "#", companyId}));
                }
                this._create();
            });
        }
        catch (Exception exception) {
            throw new UpgradeException((Throwable)exception);
        }
    }

    public String getBundleSymbolicName() {
        return this._bundle.getSymbolicName();
    }

    public String getSchemaVersion() {
        Dictionary headers = this._bundle.getHeaders("");
        return GetterUtil.getString((String)((String)headers.get("Liferay-Require-SchemaVersion")), (String)"1.0.0");
    }

    private void _create() throws UpgradeException {
        block16: {
            String indexesSQL = DBResourceUtil.getModuleIndexesSQL((Bundle)this._bundle);
            String sequencesSQL = DBResourceUtil.getModuleSequencesSQL((Bundle)this._bundle);
            String tablesSQL = DBResourceUtil.getModuleTablesSQL((Bundle)this._bundle);
            try (Connection connection = this._dataSource.getConnection();){
                if (tablesSQL != null) {
                    try {
                        this._db.runSQLTemplate(connection, tablesSQL, true);
                    }
                    catch (Exception exception) {
                        throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in tables.sql:\n", tablesSQL}), (Throwable)exception);
                    }
                }
                if (sequencesSQL != null) {
                    try {
                        this._db.runSQLTemplate(connection, sequencesSQL, true);
                    }
                    catch (Exception exception) {
                        throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in sequences.sql:\n", sequencesSQL}), (Throwable)exception);
                    }
                }
                if (indexesSQL == null) break block16;
                try {
                    this._db.runSQLTemplate(connection, indexesSQL, true);
                }
                catch (Exception exception) {
                    throw new UpgradeException(StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " has invalid content in indexes.sql:\n", indexesSQL}), (Throwable)exception);
                }
            }
            catch (SQLException sqlException) {
                throw new UpgradeException((Throwable)sqlException);
            }
        }
    }
}

