/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.bean;

import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class ApplicationContextServicePublisher {
    private final ApplicationContext _applicationContext;
    private final BundleContext _bundleContext;
    private final Logger _log;
    private final Set<ServiceRegistration<?>> _serviceRegistrations = new HashSet();

    public ApplicationContextServicePublisher(ApplicationContext applicationContext, BundleContext bundleContext) {
        this._applicationContext = applicationContext;
        this._bundleContext = bundleContext;
        this._log = new Logger(bundleContext);
    }

    public void register() {
        for (String beanName : this._applicationContext.getBeanDefinitionNames()) {
            Object bean = null;
            try {
                bean = this._applicationContext.getBean(beanName);
            }
            catch (BeanIsAbstractException biae) {
            }
            catch (Exception e) {
                this._log.log(1, "Unable to register service " + beanName, e);
            }
            if (bean == null) continue;
            this.registerService(this._bundleContext, bean);
        }
        Bundle bundle = this._bundleContext.getBundle();
        this.registerApplicationContext(this._applicationContext, bundle.getSymbolicName());
    }

    public void unregister() {
        for (ServiceRegistration<?> serviceReference : this._serviceRegistrations) {
            serviceReference.unregister();
        }
        this._serviceRegistrations.clear();
    }

    protected Dictionary<String, Object> getBeanProperties(Object object) {
        Class<?> clazz = null;
        try {
            clazz = this.getTargetClass(object);
        }
        catch (Exception e) {
            return new HashMapDictionary();
        }
        OSGiBeanProperties osgiBeanProperties = (OSGiBeanProperties)AnnotationUtils.findAnnotation(clazz, OSGiBeanProperties.class);
        if (osgiBeanProperties == null) {
            return null;
        }
        HashMapDictionary properties = new HashMapDictionary();
        properties.putAll(OSGiBeanProperties.Convert.toMap((OSGiBeanProperties)osgiBeanProperties));
        return properties;
    }

    protected Set<Class<?>> getInterfaces(Object object) throws Exception {
        Class<?> clazz = this.getTargetClass(object);
        OSGiBeanProperties osgiBeanProperties = (OSGiBeanProperties)AnnotationUtils.findAnnotation(clazz, OSGiBeanProperties.class);
        if (osgiBeanProperties == null) {
            return new HashSet(Arrays.asList(ReflectionUtil.getInterfaces((Object)object)));
        }
        Class[] serviceClasses = osgiBeanProperties.service();
        if (serviceClasses.length == 0) {
            return new HashSet(Arrays.asList(ReflectionUtil.getInterfaces((Object)object)));
        }
        for (Class serviceClazz : serviceClasses) {
            serviceClazz.cast(object);
        }
        return new HashSet(Arrays.asList(osgiBeanProperties.service()));
    }

    protected Class<?> getTargetClass(Object service) throws Exception {
        Class<?> clazz = service.getClass();
        if (ProxyUtil.isProxyClass(clazz)) {
            AdvisedSupport advisedSupport = ServiceBeanAopProxy.getAdvisedSupport((Object)service);
            TargetSource targetSource = advisedSupport.getTargetSource();
            Object target = targetSource.getTarget();
            clazz = target.getClass();
        }
        return clazz;
    }

    protected boolean isIgnoredInterface(String interfaceClassName) {
        for (String ignoredInterfaceClassName : PropsValues.MODULE_FRAMEWORK_SERVICES_IGNORED_INTERFACES) {
            if (ignoredInterfaceClassName.startsWith("!") || !ignoredInterfaceClassName.equals(interfaceClassName) && (!ignoredInterfaceClassName.endsWith("*") || !interfaceClassName.startsWith(ignoredInterfaceClassName.substring(0, ignoredInterfaceClassName.length() - 1)))) continue;
            return true;
        }
        return false;
    }

    protected void registerApplicationContext(ApplicationContext applicationContext, String bundleSymbolicName) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put((Object)"org.springframework.context.service.name", (Object)bundleSymbolicName);
        this.registerService(this._bundleContext, applicationContext, Arrays.asList(ApplicationContext.class.getName()), (Dictionary<String, Object>)properties);
    }

    protected void registerService(BundleContext bundleContext, Object bean) {
        Set<Class<?>> interfaces = null;
        try {
            interfaces = this.getInterfaces(bean);
        }
        catch (Exception e) {
            this._log.log(1, "Unable to register service " + bean, e);
        }
        interfaces.add(bean.getClass());
        ArrayList<String> names = new ArrayList<String>(interfaces.size());
        for (Class<?> interfaceClass : interfaces) {
            String interfaceClassName = interfaceClass.getName();
            if (this.isIgnoredInterface(interfaceClassName)) continue;
            names.add(interfaceClassName);
        }
        if (names.isEmpty()) {
            this._log.log(4, "Skipping registration because of an empty list of interfaces");
            return;
        }
        this.registerService(bundleContext, bean, names, this.getBeanProperties(bean));
    }

    protected void registerService(BundleContext bundleContext, Object bean, List<String> interfaces, Dictionary<String, Object> properties) {
        ServiceRegistration serviceRegistration = bundleContext.registerService(interfaces.toArray(new String[interfaces.size()]), bean, properties);
        this._serviceRegistrations.add(serviceRegistration);
    }
}

