/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.bean;

import com.liferay.portal.spring.extender.service.ServiceReference;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.util.ReflectionUtils;

public class ServiceReferenceAnnotationBeanPostProcessor
implements ApplicationListener<ContextClosedEvent>,
BeanPostProcessor {
    private final BundleContext _bundleContext;
    private final Set<org.osgi.framework.ServiceReference<?>> _serviceReferences = new HashSet();

    public ServiceReferenceAnnotationBeanPostProcessor(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        for (org.osgi.framework.ServiceReference<?> serviceReference : this._serviceReferences) {
            this._bundleContext.ungetService(serviceReference);
        }
        this._serviceReferences.clear();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.autoInject(bean, bean.getClass());
        return bean;
    }

    protected void autoInject(Object targetBean, Class<?> beanClass) {
        Field[] fields;
        if (beanClass == null || beanClass.isInterface()) {
            return;
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            ServiceReference serviceReference = field.getAnnotation(ServiceReference.class);
            if (serviceReference == null) continue;
            Class<?> typeClass = serviceReference.type();
            org.osgi.framework.ServiceReference osgiServiceReference = this._bundleContext.getServiceReference(typeClass.getName());
            ReflectionUtils.makeAccessible((Field)field);
            try {
                field.set(targetBean, this._bundleContext.getService(osgiServiceReference));
            }
            catch (Throwable t) {
                throw new BeanCreationException(beanClass.getName(), "Unable to inject bean reference fields", t);
            }
            this._serviceReferences.add(osgiServiceReference);
        }
        this.autoInject(targetBean, beanClass.getSuperclass());
    }
}

