/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

public class BundleResolverClassLoader
extends ClassLoader {
    private final Bundle[] _bundles;

    public BundleResolverClassLoader(Bundle ... bundles) {
        if (bundles.length == 0) {
            throw new IllegalArgumentException("At least one bundle is required");
        }
        this._bundles = bundles;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.findResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (Bundle bundle : this._bundles) {
            try {
                return bundle.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (Bundle bundle : this._bundles) {
            URL url = bundle.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        for (Bundle bundle : this._bundles) {
            try {
                Enumeration resources = bundle.getResources(name);
                if (resources == null || !resources.hasMoreElements()) continue;
                return resources;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return Collections.enumeration(Collections.emptyList());
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

