/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.context;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBContext;
import com.liferay.portal.kernel.dao.db.DBManager;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.configuration.configurator.ServiceConfigurator;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.spring.extender.internal.context.ModuleApplicationContextRegistrator;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistratorTracker;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import javax.sql.DataSource;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.utils.extender.AbstractExtender;
import org.apache.felix.utils.extender.Extension;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ModuleApplicationContextExtender
extends AbstractExtender {
    private BundleContext _bundleContext;
    private DependencyManager _dependencyManager;
    private Logger _logger;
    private ServiceConfigurator _serviceConfigurator;

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this.setSynchronous(true);
        this._bundleContext = bundleContext;
        this._dependencyManager = new DependencyManager(bundleContext);
        this._logger = new Logger(bundleContext);
        this.start(bundleContext);
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.stop(this._bundleContext);
        this._bundleContext = null;
    }

    @Override
    protected void debug(Bundle bundle, String s) {
        this._logger.log(4, "[" + bundle + "] " + s);
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        Dictionary headers = bundle.getHeaders();
        if (headers.get("Liferay-Spring-Context") == null) {
            return null;
        }
        return new ModuleApplicationContextExtension(bundle);
    }

    @Override
    protected void error(String s, Throwable throwable) {
        this._logger.log(1, s, throwable);
    }

    @Reference(target="(&(bean.id=liferayDataSource)(original.bean=true))", unbind="-")
    protected void setDataSource(DataSource dataSource) {
    }

    @Reference(target="(original.bean=true)", unbind="-")
    protected void setInfrastructureUtil(InfrastructureUtil infrastructureUtil) {
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(target="(original.bean=true)", unbind="-")
    protected void setSaxReaderUtil(SAXReaderUtil saxReaderUtil) {
    }

    @Reference(target="(original.bean=true)", unbind="-")
    protected void setServiceConfigurator(ServiceConfigurator serviceConfigurator) {
        this._serviceConfigurator = serviceConfigurator;
    }

    @Override
    protected void warn(Bundle bundle, String s, Throwable throwable) {
        this._logger.log(4, "[" + bundle + "] " + s);
    }

    private class ModuleApplicationContextExtension
    implements Extension {
        private final Bundle _bundle;
        private org.apache.felix.dm.Component _component;
        private List<ServiceRegistration<UpgradeStep>> _upgradeStepServiceRegistrations;

        public ModuleApplicationContextExtension(Bundle bundle) {
            this._bundle = bundle;
        }

        @Override
        public void destroy() throws Exception {
            for (ServiceRegistration<UpgradeStep> upgradeStepServiceRegistration : this._upgradeStepServiceRegistrations) {
                upgradeStepServiceRegistration.unregister();
            }
            if (this._component != null) {
                ModuleApplicationContextExtender.this._dependencyManager.remove(this._component);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getSQLTemplateString(String templateName) throws UpgradeException {
            URL resource = this._bundle.getResource("/META-INF/sql/" + templateName);
            if (resource == null) {
                throw new UpgradeException("Unable to locate SQL template " + templateName);
            }
            try (InputStream inputStream = resource.openStream();){
                String string = StringUtil.read((InputStream)inputStream);
                return string;
            }
            catch (IOException ioe) {
                throw new UpgradeException("Unable to read SQL template " + templateName, (Throwable)ioe);
            }
        }

        @Override
        public void start() throws Exception {
            this._component = ModuleApplicationContextExtender.this._dependencyManager.createComponent();
            this._component.setImplementation((Object)new ModuleApplicationContextRegistrator(this._bundle, ModuleApplicationContextExtender.this._bundleContext.getBundle(), ModuleApplicationContextExtender.this._serviceConfigurator));
            BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
            ClassLoader classLoader = bundleWiring.getClassLoader();
            List<ContextDependency> contextDependencies = this._processServiceReferences(this._bundle);
            for (ContextDependency contextDependency : contextDependencies) {
                ServiceDependency serviceDependency = ModuleApplicationContextExtender.this._dependencyManager.createServiceDependency();
                serviceDependency.setRequired(true);
                Class<?> serviceClass = Class.forName(contextDependency.getServiceClassName(), false, classLoader);
                serviceDependency.setService(serviceClass, contextDependency.getFilterString());
                this._component.add((Dependency)serviceDependency);
            }
            Dictionary headers = this._bundle.getHeaders();
            String requireSchemaVersion = (String)headers.get("Liferay-Require-SchemaVersion");
            if (Validator.isNull((String)requireSchemaVersion)) {
                this._generateReleaseInfo();
            }
            ModuleApplicationContextExtender.this._dependencyManager.add(this._component);
            this._upgradeStepServiceRegistrations = this._processInitialUpgrade();
        }

        private void _generateReleaseInfo() {
            ServiceDependency serviceDependency = ModuleApplicationContextExtender.this._dependencyManager.createServiceDependency();
            serviceDependency.setRequired(true);
            serviceDependency.setService(Release.class, "(&(release.bundle.symbolic.name=" + this._bundle.getSymbolicName() + ")(release.schema.version=" + this._bundle.getVersion() + "))");
            this._component.add((Dependency)serviceDependency);
        }

        private List<ServiceRegistration<UpgradeStep>> _processInitialUpgrade() {
            Dictionary headers = this._bundle.getHeaders();
            String upgradeToSchemaVersion = GetterUtil.getString((String)((String)headers.get("Liferay-Require-SchemaVersion")), (String)((String)headers.get("Bundle-Version")));
            return UpgradeStepRegistratorTracker.register((BundleContext)ModuleApplicationContextExtender.this._bundleContext, (String)this._bundle.getSymbolicName(), (String)"0.0.0", (String)upgradeToSchemaVersion, (UpgradeStep[])new UpgradeStep[]{new UpgradeStep(){

                public void upgrade(DBProcessContext dbProcessContext) {
                    DBContext dbContext = dbProcessContext.getDBContext();
                    DBManager dbManager = dbContext.getDBManager();
                    DB db = dbManager.getDB();
                    try {
                        db.runSQLTemplateString(ModuleApplicationContextExtension.this.getSQLTemplateString("tables.sql"), true, true);
                        db.runSQLTemplateString(ModuleApplicationContextExtension.this.getSQLTemplateString("sequences.sql"), true, true);
                        db.runSQLTemplateString(ModuleApplicationContextExtension.this.getSQLTemplateString("indexes.sql"), true, true);
                    }
                    catch (Exception e) {
                        new UpgradeException((Throwable)e);
                    }
                }
            }});
        }

        private List<ContextDependency> _processServiceReferences(Bundle bundle) throws IOException {
            ArrayList<ContextDependency> contextDependencies = new ArrayList<ContextDependency>();
            URL url = bundle.getEntry("OSGI-INF/context/context.dependencies");
            if (url == null) {
                return contextDependencies;
            }
            ArrayList lines = new ArrayList();
            StringUtil.readLines((InputStream)url.openStream(), lines);
            for (String line : lines) {
                if (Validator.isNull((String)line)) continue;
                line = line.trim();
                String[] array = line.split(" ");
                String filterString = "";
                if (array.length > 1) {
                    filterString = array[1];
                }
                contextDependencies.add(new ContextDependency(array[0], filterString));
            }
            return contextDependencies;
        }

        private class ContextDependency {
            protected String filterString;
            protected final String serviceClassName;

            public ContextDependency(String serviceClassName, String filterString) {
                this.serviceClassName = serviceClassName;
                if (!filterString.equals("")) {
                    this.filterString = filterString;
                }
            }

            public String getFilterString() {
                return this.filterString;
            }

            public String getServiceClassName() {
                return this.serviceClassName;
            }
        }
    }
}

