/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.service.configuration.ServiceComponentConfiguration;
import com.liferay.portal.kernel.service.configuration.configurator.ServiceConfigurator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.spring.bean.BeanReferenceRefreshUtil;
import com.liferay.portal.spring.extender.internal.bean.ApplicationContextServicePublisher;
import com.liferay.portal.spring.extender.internal.bundle.CompositeResourceLoaderBundle;
import com.liferay.portal.spring.extender.internal.classloader.BundleResolverClassLoader;
import com.liferay.portal.spring.extender.internal.context.ModuleApplicationContext;
import com.liferay.portal.spring.extender.internal.context.ModuleBeanFactoryPostProcessor;
import com.liferay.portal.spring.extender.internal.context.SpringContextHeaderParser;
import com.liferay.portal.spring.extender.loader.ModuleResourceLoader;
import java.beans.Introspector;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ModuleApplicationContextRegistrator {
    private ApplicationContextServicePublisher _applicationContextServicePublisher;
    private ConfigurableApplicationContext _configurableApplicationContext;
    private final Bundle _extendeeBundle;
    private final ClassLoader _extendeeClassLoader;
    private final Bundle _extenderBundle;
    private final Logger _logger;
    private final ServiceConfigurator _serviceConfigurator;

    public ModuleApplicationContextRegistrator(Bundle extendeeBundle, Bundle extenderBundle, ServiceConfigurator serviceConfigurator) {
        this._extendeeBundle = extendeeBundle;
        this._extenderBundle = extenderBundle;
        this._serviceConfigurator = serviceConfigurator;
        BundleWiring bundleWiring = (BundleWiring)this._extendeeBundle.adapt(BundleWiring.class);
        this._extendeeClassLoader = bundleWiring.getClassLoader();
        this._logger = new Logger(this._extendeeBundle.getBundleContext());
    }

    protected void start() throws Exception {
        try {
            ConfigurableApplicationContext configurableApplicationContext = this._createApplicationContext(this._extenderBundle, this._extendeeBundle);
            this._registerBeanLocator(this._extendeeBundle, (ApplicationContext)configurableApplicationContext);
            this._refreshBeanFactory((ApplicationContext)configurableApplicationContext);
            this._serviceConfigurator.initServices((ServiceComponentConfiguration)new ModuleResourceLoader(this._extendeeBundle), this._extendeeClassLoader);
            this._configurableApplicationContext = configurableApplicationContext;
            this._applicationContextServicePublisher = new ApplicationContextServicePublisher((ApplicationContext)this._configurableApplicationContext, this._extendeeBundle.getBundleContext());
            this._applicationContextServicePublisher.register();
        }
        catch (Exception e) {
            this._logger.log(1, "Unable to start " + this._extendeeBundle.getSymbolicName(), e);
            throw e;
        }
    }

    protected void stop() throws Exception {
        this._cleanInstropectionCaches(this._extendeeBundle);
        this._applicationContextServicePublisher.unregister();
        PortletBeanLocatorUtil.setBeanLocator((String)this._extendeeBundle.getSymbolicName(), null);
        this._serviceConfigurator.destroyServices((ServiceComponentConfiguration)new ModuleResourceLoader(this._extendeeBundle), this._extendeeClassLoader);
        this._configurableApplicationContext.close();
        this._configurableApplicationContext = null;
    }

    private void _cleanInstropectionCaches(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        CachedIntrospectionResults.clearClassLoader((ClassLoader)bundleWiring.getClassLoader());
        Introspector.flushCaches();
    }

    private ConfigurableApplicationContext _createApplicationContext(Bundle extender, Bundle extendee) throws RuntimeException {
        SpringContextHeaderParser springContextHeaderParser = new SpringContextHeaderParser(extendee);
        Object[] beanDefinitionFileNames = springContextHeaderParser.getBeanDefinitionFileNames();
        if (ArrayUtil.isEmpty((Object[])beanDefinitionFileNames)) {
            return null;
        }
        BundleResolverClassLoader classLoader = new BundleResolverClassLoader(extendee, extender);
        CompositeResourceLoaderBundle compositeResourceLoaderBundle = new CompositeResourceLoaderBundle(extendee, extender);
        ModuleApplicationContext moduleApplicationContext = new ModuleApplicationContext(compositeResourceLoaderBundle, classLoader, (String[])beanDefinitionFileNames);
        moduleApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new ModuleBeanFactoryPostProcessor(classLoader, extendee.getBundleContext()));
        moduleApplicationContext.refresh();
        return moduleApplicationContext;
    }

    private void _refreshBeanFactory(ApplicationContext applicationContext) {
        try {
            BeanReferenceRefreshUtil.refresh((BeanFactory)applicationContext.getAutowireCapableBeanFactory());
        }
        catch (Exception e) {
            this._logger.log(1, "Unable to refresh " + applicationContext.getDisplayName() + ". This may result in memory leaks on multiple " + "redeployments.");
        }
    }

    private void _registerBeanLocator(Bundle bundle, ApplicationContext applicationContext) {
        BundleResolverClassLoader classLoader = new BundleResolverClassLoader(bundle);
        PortletBeanLocatorUtil.setBeanLocator((String)bundle.getSymbolicName(), (BeanLocator)new BeanLocatorImpl((ClassLoader)classLoader, applicationContext));
    }
}

