/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.extender.internal.hibernate.session;

import com.liferay.portal.dao.orm.hibernate.PortletSessionFactoryImpl;
import com.liferay.portal.spring.extender.internal.classloader.BundleResolverClassLoader;
import com.liferay.portal.spring.extender.internal.context.ModuleApplicationContext;
import com.liferay.portal.spring.extender.internal.hibernate.configuration.ModuleHibernateConfiguration;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ModuleSessionFactory
extends PortletSessionFactoryImpl
implements ApplicationContextAware {
    private ClassLoader _classLoader;

    public ClassLoader getSessionFactoryClassLoader() {
        return this._classLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ModuleApplicationContext moduleApplicationContext = (ModuleApplicationContext)applicationContext;
        BundleContext bundleContext = moduleApplicationContext.getBundleContext();
        this._classLoader = new BundleResolverClassLoader(bundleContext.getBundle());
        this.setSessionFactoryClassLoader(this._classLoader);
    }

    protected SessionFactory createSessionFactory(DataSource dataSource) {
        ModuleHibernateConfiguration moduleHibernateConfiguration = new ModuleHibernateConfiguration(this._classLoader);
        moduleHibernateConfiguration.setDataSource(dataSource);
        try {
            return moduleHibernateConfiguration.buildSessionFactory();
        }
        catch (Exception e) {
            return null;
        }
    }
}

