/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.azure;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.logging.LogLevel;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.batch.BlobBatch;
import com.azure.storage.blob.batch.BlobBatchClient;
import com.azure.storage.blob.batch.BlobBatchClientBuilder;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.azure.configuration.AzureStoreConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.store.azure.configuration.AzureStoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"store.type=com.liferay.portal.store.azure.AzureStore"}, service={Store.class})
public class AzureStore
implements Store {
    private static final Log _log = LogFactoryUtil.getLog(AzureStore.class);
    private volatile BlobContainerClient _blobContainerClient;

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) throws PortalException {
        BlobClient blobClient = this._blobContainerClient.getBlobClient(this._getAzurePath(companyId, repositoryId, fileName, versionLabel));
        File tempFile = null;
        try {
            tempFile = FileUtil.createTempFile((InputStream)inputStream);
            blobClient.uploadFromFile(tempFile.getAbsolutePath(), true);
        }
        catch (IOException ioException) {
            throw new PortalException("Unable to create temp file", (Throwable)ioException);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw new PortalException("Unable to add file", (Throwable)uncheckedIOException);
        }
        finally {
            FileUtil.delete((File)tempFile);
        }
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        BlobBatchClient blobBatchClient = new BlobBatchClientBuilder(this._blobContainerClient.getServiceClient()).buildClient();
        ListBlobsOptions listBlobsOptions = new ListBlobsOptions();
        listBlobsOptions.setMaxResultsPerPage(Integer.valueOf(256));
        listBlobsOptions.setPrefix(this._getPrefix(companyId, repositoryId, dirName));
        PagedIterable pagedIterable = this._blobContainerClient.listBlobs(listBlobsOptions, null);
        for (PagedResponse pagedResponse : pagedIterable.iterableByPage()) {
            BlobBatch blobBatch = blobBatchClient.getBlobBatch();
            List blobItems = pagedResponse.getValue();
            ArrayList responses = new ArrayList(blobItems.size());
            blobItems.forEach(blobItem -> responses.add(blobBatch.deleteBlob(this._blobContainerClient.getBlobContainerName(), blobItem.getName())));
            if (!blobItems.isEmpty()) {
                blobBatchClient.submitBatchWithResponse(blobBatch, false, null, Context.NONE);
            }
            for (Response response : responses) {
                if (response.getStatusCode() < 400) continue;
                HttpRequest httpRequest = response.getRequest();
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to delete ", httpRequest.getUrl(), " due to status code ", response.getStatusCode()}));
            }
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        BlobClient blobClient = this._blobContainerClient.getBlobClient(this._getAzurePath(companyId, repositoryId, fileName, versionLabel));
        if (blobClient.exists().booleanValue()) {
            blobClient.delete();
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        BlobClient blobClient;
        if (Validator.isNull((String)versionLabel)) {
            versionLabel = this._getFirstFileVersion(companyId, repositoryId, fileName);
        }
        if (!(blobClient = this._blobContainerClient.getBlobClient(this._getAzurePath(companyId, repositoryId, fileName, versionLabel))).exists().booleanValue()) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
        }
        return blobClient.openInputStream();
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        ArrayList fileNames = new ArrayList();
        ListBlobsOptions listBlobsOptions = new ListBlobsOptions();
        listBlobsOptions.setPrefix(this._getPrefix(companyId, repositoryId, dirName));
        PagedIterable pagedIterable = this._blobContainerClient.listBlobs(listBlobsOptions, null);
        pagedIterable.forEach(blobItem -> fileNames.add(this._getFileName(companyId, repositoryId, blobItem.getName())));
        return fileNames.toArray(new String[0]);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        BlobClient blobClient;
        if (Validator.isNull((String)versionLabel)) {
            versionLabel = this._getFirstFileVersion(companyId, repositoryId, fileName);
        }
        if (!(blobClient = this._blobContainerClient.getBlobClient(this._getAzurePath(companyId, repositoryId, fileName, versionLabel))).exists().booleanValue()) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
        }
        BlobProperties blobProperties = blobClient.getProperties();
        return blobProperties.getBlobSize();
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        ArrayList fileVersions = new ArrayList();
        ListBlobsOptions listBlobsOptions = new ListBlobsOptions();
        String prefix = this._getPrefix(companyId, repositoryId, fileName);
        listBlobsOptions.setPrefix(prefix);
        PagedIterable pagedIterable = this._blobContainerClient.listBlobsByHierarchy("/", listBlobsOptions, null);
        pagedIterable.forEach(blobItem -> {
            if (GetterUtil.getBoolean((Object)blobItem.isPrefix())) {
                return;
            }
            String blobItemName = blobItem.getName();
            fileVersions.add(blobItemName.substring(prefix.length()));
        });
        Collections.sort(fileVersions, DLUtil::compareVersions);
        return fileVersions.toArray(new String[0]);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        if (Validator.isNull((String)versionLabel)) {
            Object[] versions = this.getFileVersions(companyId, repositoryId, fileName);
            return ArrayUtil.isNotEmpty((Object[])versions);
        }
        BlobClient blobClient = this._blobContainerClient.getBlobClient(this._getAzurePath(companyId, repositoryId, fileName, versionLabel));
        return blobClient.exists();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        BlobContainerClientBuilder blobContainerClientBuilder = new BlobContainerClientBuilder();
        AzureStoreConfiguration azureStoreConfiguration = (AzureStoreConfiguration)ConfigurableUtil.createConfigurable(AzureStoreConfiguration.class, properties);
        Configuration globalConfiguration = Configuration.getGlobalConfiguration();
        HttpLogOptions httpLogOptions = BlobServiceClientBuilder.getDefaultHttpLogOptions();
        if (azureStoreConfiguration.httpLoggingEnabled()) {
            blobContainerClientBuilder.configuration(globalConfiguration.put("AZURE_LOG_LEVEL", String.valueOf(LogLevel.VERBOSE.getLogLevel()))).httpLogOptions(httpLogOptions.setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS));
        } else {
            blobContainerClientBuilder.configuration(globalConfiguration.put("AZURE_LOG_LEVEL", String.valueOf(LogLevel.NOT_SET.getLogLevel()))).httpLogOptions(httpLogOptions.setLogLevel(HttpLogDetailLevel.NONE));
        }
        blobContainerClientBuilder.connectionString(azureStoreConfiguration.connectionString());
        blobContainerClientBuilder.containerName(azureStoreConfiguration.containerName());
        if (Validator.isNotNull((String)azureStoreConfiguration.encryptionScope())) {
            blobContainerClientBuilder.encryptionScope(azureStoreConfiguration.encryptionScope());
        }
        this._blobContainerClient = blobContainerClientBuilder.buildClient();
        if (!this._blobContainerClient.exists()) {
            throw new SystemException("Azure store " + this._blobContainerClient.getBlobContainerName() + " does not exist");
        }
    }

    @Deactivate
    protected void deactivate() {
        this._blobContainerClient = null;
    }

    private String _getAzurePath(long companyId, long repositoryId, String liferayPath, String versionLabel) {
        if (StringUtil.startsWith((String)liferayPath, (String)"/")) {
            liferayPath = liferayPath.substring(1);
        }
        if (StringUtil.endsWith((String)liferayPath, (String)"/")) {
            liferayPath = liferayPath.substring(0, liferayPath.length() - 1);
        }
        StringBundler sb = new StringBundler(7);
        sb.append(companyId);
        sb.append("/");
        sb.append(repositoryId);
        if (!liferayPath.isEmpty()) {
            sb.append("/");
            sb.append(liferayPath);
        }
        if (Validator.isNotNull((String)versionLabel)) {
            sb.append("/");
            sb.append(versionLabel);
        }
        return sb.toString();
    }

    private String _getFileName(long companyId, long repositoryId, String blobItemName) {
        Objects.requireNonNull(blobItemName);
        String prefix = this._getAzurePath(companyId, repositoryId, "", null) + "/";
        if (!blobItemName.startsWith(prefix)) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Blob ", blobItemName, " does not belong to company ", companyId, " and repository ", repositoryId}));
        }
        String fileNameAndVersionLabel = blobItemName.substring(prefix.length());
        if (fileNameAndVersionLabel.isEmpty() || !fileNameAndVersionLabel.contains("/")) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Blob ", blobItemName, " does not conform to the pattern ", "${companyId}/${repositoryId}/${fileName}", "/${versionLabel}"}));
        }
        return fileNameAndVersionLabel.substring(0, fileNameAndVersionLabel.lastIndexOf("/"));
    }

    private String _getFirstFileVersion(long companyId, long repositoryId, String fileName) throws NoSuchFileException {
        Object[] fileVersions = this.getFileVersions(companyId, repositoryId, fileName);
        if (ArrayUtil.isEmpty((Object[])fileVersions)) {
            throw new NoSuchFileException(companyId, repositoryId, fileName);
        }
        return fileVersions[0];
    }

    private String _getPrefix(long companyId, long repositoryId, String dirName) {
        return this._getAzurePath(companyId, repositoryId, dirName, null) + "/";
    }
}

