/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.db;

import com.liferay.document.library.content.exception.NoSuchContentException;
import com.liferay.document.library.content.model.DLContent;
import com.liferay.document.library.content.service.DLContentLocalService;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.string.StringPool;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ct.aware=true", "store.type=com.liferay.portal.store.db.DBStore"}, service={Store.class})
public class DBStore
implements Store {
    @Reference
    private DLContentLocalService _dlContentLocalService;

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) {
        this._dlContentLocalService.addContent(companyId, repositoryId, fileName, versionLabel, inputStream);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        this._dlContentLocalService.deleteContentsByDirectory(companyId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        this._dlContentLocalService.deleteContent(companyId, repositoryId, fileName, versionLabel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        try {
            DLContent dlContent = this._dlContentLocalService.getContent(companyId, repositoryId, fileName, versionLabel);
            return this._dlContentLocalService.openDataInputStream(dlContent.getContentId());
        }
        catch (NoSuchContentException noSuchContentException) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel, (Throwable)noSuchContentException);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        List dlContents = this._dlContentLocalService.getContentsByDirectory(companyId, repositoryId, dirName);
        String[] fileNames = new String[dlContents.size()];
        for (int i = 0; i < dlContents.size(); ++i) {
            DLContent dlContent = (DLContent)dlContents.get(i);
            fileNames[i] = dlContent.getPath();
        }
        return fileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        DLContent dlContent = null;
        try {
            dlContent = this._dlContentLocalService.getContent(companyId, repositoryId, fileName, versionLabel);
        }
        catch (NoSuchContentException noSuchContentException) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, (Throwable)noSuchContentException);
        }
        return dlContent.getSize();
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        List dlContents = this._dlContentLocalService.getContents(companyId, repositoryId, fileName);
        if (dlContents.isEmpty()) {
            return StringPool.EMPTY_ARRAY;
        }
        String[] versions = new String[dlContents.size()];
        for (int i = 0; i < dlContents.size(); ++i) {
            DLContent dlContent = (DLContent)dlContents.get(i);
            versions[i] = dlContent.getVersion();
        }
        Arrays.sort(versions, DLUtil::compareVersions);
        return versions;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        return this._dlContentLocalService.hasContent(companyId, repositoryId, fileName, versionLabel);
    }
}

