/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.file.system;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.convert.documentlibrary.FileSystemStoreRootDirException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.file.system.AdvancedFileSystemStore;
import com.liferay.portal.store.file.system.configuration.AdvancedFileSystemStoreConfiguration;
import com.liferay.portal.store.file.system.lenient.LenientStore;
import com.liferay.portal.store.file.system.safe.file.name.SafeFileNameStore;
import com.liferay.portal.util.PropsUtil;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.portal.store.file.system.configuration.AdvancedFileSystemStoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class AdvancedFileSystemStoreRegister {
    private ServiceRegistration<Store> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        AdvancedFileSystemStoreConfiguration advancedFileSystemStoreConfiguration = (AdvancedFileSystemStoreConfiguration)ConfigurableUtil.createConfigurable(AdvancedFileSystemStoreConfiguration.class, properties);
        if (Validator.isBlank((String)advancedFileSystemStoreConfiguration.rootDir())) {
            throw new IllegalArgumentException("Advanced file system root directory is not set", (Throwable)new FileSystemStoreRootDirException());
        }
        AdvancedFileSystemStore advancedFileSystemStore = new AdvancedFileSystemStore(advancedFileSystemStoreConfiguration);
        this._serviceRegistration = bundleContext.registerService(Store.class, (Object)this._wrapStore(advancedFileSystemStore), (Dictionary)HashMapDictionaryBuilder.put((Object)"rootDir", (Object)advancedFileSystemStore.getRootDir()).put((Object)"store.type", (Object)AdvancedFileSystemStore.class.getName()).build());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private Store _wrapStore(Store store) {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"dl.store.file.system.lenient"))) {
            return new SafeFileNameStore(store);
        }
        return new LenientStore(new SafeFileNameStore(store));
    }
}

