/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.file.system;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.convert.documentlibrary.FileSystemStoreRootDirException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.file.system.FileSystemStore;
import com.liferay.portal.store.file.system.configuration.FileSystemStoreConfiguration;
import com.liferay.portal.store.file.system.lenient.LenientStore;
import com.liferay.portal.store.file.system.safe.file.name.SafeFileNameStore;
import com.liferay.portal.util.PropsUtil;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.portal.store.file.system.configuration.FileSystemStoreConfiguration"}, service={})
public class FileSystemStoreRegister {
    private ServiceRegistration<Store> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        FileSystemStoreConfiguration fileSystemStoreConfiguration = (FileSystemStoreConfiguration)ConfigurableUtil.createConfigurable(FileSystemStoreConfiguration.class, properties);
        if (Validator.isBlank((String)fileSystemStoreConfiguration.rootDir())) {
            throw new IllegalArgumentException("File system root directory is not set", (Throwable)new FileSystemStoreRootDirException());
        }
        FileSystemStore fileSystemStore = new FileSystemStore(fileSystemStoreConfiguration);
        this._serviceRegistration = bundleContext.registerService(Store.class, (Object)this._wrapStore(fileSystemStore), (Dictionary)HashMapDictionaryBuilder.put((Object)"rootDir", (Object)fileSystemStore.getRootDir()).put((Object)"store.type", (Object)FileSystemStore.class.getName()).build());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private Store _wrapStore(Store store) {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"dl.store.file.system.lenient"))) {
            return new SafeFileNameStore(store);
        }
        return new LenientStore(new SafeFileNameStore(store));
    }
}

