/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.file.system.lenient;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.exception.PortalException;
import java.io.InputStream;

public class LenientStore
implements Store {
    private static final byte[] _DUMMY_CONTENT = "This is a test file.".getBytes();
    private final Store _store;

    public LenientStore(Store store) {
        this._store = store;
    }

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) throws PortalException {
        this._store.addFile(companyId, repositoryId, fileName, versionLabel, inputStream);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        this._store.deleteDirectory(companyId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        if (!this._store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            this._store.addFile(companyId, repositoryId, fileName, versionLabel, (InputStream)new UnsyncByteArrayInputStream(_DUMMY_CONTENT));
        }
        return this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        return this._store.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        if (!this._store.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            this._store.addFile(companyId, repositoryId, fileName, versionLabel, (InputStream)new UnsyncByteArrayInputStream(_DUMMY_CONTENT));
        }
        return this._store.getFileSize(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        return this._store.getFileVersions(companyId, repositoryId, fileName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        return true;
    }
}

