/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.file.system;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.store.file.system.FileSystemStore;
import com.liferay.portal.store.file.system.configuration.AdvancedFileSystemStoreConfiguration;
import java.io.File;
import java.util.List;
import java.util.ListIterator;

public class AdvancedFileSystemStore
extends FileSystemStore {
    private static final String _HOOK_EXTENSION = "afsh";

    public AdvancedFileSystemStore(AdvancedFileSystemStoreConfiguration advancedFileSystemStoreConfiguration) {
        super(advancedFileSystemStoreConfiguration);
    }

    @Override
    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        String[] versions = super.getFileVersions(companyId, repositoryId, fileName);
        for (int i = 0; i < versions.length; ++i) {
            int x = versions[i].lastIndexOf(95);
            if (x <= -1) continue;
            int y = versions[i].lastIndexOf(46);
            versions[i] = versions[i].substring(x + 1, y);
        }
        return versions;
    }

    protected void buildPath(StringBundler sb, String fileNameFragment) {
        int fileNameFragmentLength = fileNameFragment.length();
        if (fileNameFragmentLength <= 2) {
            return;
        }
        int i = 0;
        while (i + 2 < fileNameFragmentLength) {
            sb.append(fileNameFragment.substring(i, i + 2));
            sb.append("/");
            if (this.getDepth(sb.toString()) > 3) {
                return;
            }
            i += 2;
        }
    }

    protected int getDepth(String path) {
        String[] fragments = StringUtil.split((String)path, (char)'/');
        return fragments.length;
    }

    @Override
    protected File getDirNameDir(long companyId, long repositoryId, String dirName) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        return new File(repositoryDir + "/" + dirName);
    }

    @Override
    protected File getFileNameDir(long companyId, long repositoryId, String fileName) {
        if (fileName.indexOf(47) != -1) {
            return this.getDirNameDir(companyId, repositoryId, fileName);
        }
        String ext = "." + FileUtil.getExtension((String)fileName);
        if (ext.equals(".")) {
            ext = ext + _HOOK_EXTENSION;
        }
        StringBundler sb = new StringBundler();
        String fileNameFragment = FileUtil.stripExtension((String)fileName);
        if (fileNameFragment.startsWith("DLFE-")) {
            fileNameFragment = fileNameFragment.substring(5);
            sb.append("DLFE/");
        }
        this.buildPath(sb, fileNameFragment);
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        StringBundler pathSB = new StringBundler(6);
        pathSB.append((Object)repositoryDir);
        pathSB.append("/");
        pathSB.append(sb.toString());
        FileUtil.mkdirs((String)pathSB.toString());
        pathSB.append("/");
        pathSB.append(fileNameFragment);
        pathSB.append(ext);
        return new File(pathSB.toString());
    }

    @Override
    protected void getFileNames(List<String> fileNames, String dirName, String path) {
        super.getFileNames(fileNames, dirName, path);
        ListIterator<String> iterator = fileNames.listIterator();
        while (iterator.hasNext()) {
            String shortFileName = iterator.next();
            if (path.endsWith(_HOOK_EXTENSION)) {
                shortFileName = FileUtil.stripExtension((String)shortFileName);
            }
            iterator.set(this.unbuildPath(shortFileName));
        }
    }

    @Override
    protected File getFileNameVersionFile(long companyId, long repositoryId, String fileName, String version) {
        int pos;
        String ext = "." + FileUtil.getExtension((String)fileName);
        if (ext.equals(".")) {
            ext = ext + _HOOK_EXTENSION;
        }
        if ((pos = fileName.lastIndexOf(47)) == -1) {
            StringBundler sb = new StringBundler();
            String fileNameFragment = FileUtil.stripExtension((String)fileName);
            if (fileNameFragment.startsWith("DLFE-")) {
                fileNameFragment = fileNameFragment.substring(5);
                sb.append("DLFE/");
            }
            this.buildPath(sb, fileNameFragment);
            File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
            StringBundler pathSB = new StringBundler(11);
            pathSB.append((Object)repositoryDir);
            pathSB.append("/");
            pathSB.append(sb.toString());
            pathSB.append("/");
            pathSB.append(fileNameFragment);
            pathSB.append(ext);
            pathSB.append("/");
            pathSB.append(fileNameFragment);
            pathSB.append("_");
            pathSB.append(version);
            pathSB.append(ext);
            return new File(pathSB.toString());
        }
        File fileNameDir = this.getDirNameDir(companyId, repositoryId, fileName);
        String fileNameFragment = FileUtil.stripExtension((String)fileName.substring(pos + 1));
        StringBundler pathSB = new StringBundler(6);
        pathSB.append((Object)fileNameDir);
        pathSB.append("/");
        pathSB.append(fileNameFragment);
        pathSB.append("_");
        pathSB.append(version);
        pathSB.append(ext);
        return new File(pathSB.toString());
    }

    @Override
    protected String getHeadVersionLabel(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return "1.0";
        }
        String[] versionLabels = FileUtil.listFiles((File)fileNameDir);
        String headVersionLabel = "1.0";
        for (String versionLabelFragment : versionLabels) {
            String versionLabel;
            int x = versionLabelFragment.lastIndexOf(95);
            if (x > -1) {
                int y = versionLabelFragment.lastIndexOf(46);
                versionLabelFragment = versionLabelFragment.substring(x + 1, y);
            }
            if (DLUtil.compareVersions((String)(versionLabel = versionLabelFragment), (String)headVersionLabel) <= 0) continue;
            headVersionLabel = versionLabel;
        }
        return headVersionLabel;
    }

    protected String unbuildPath(String path) {
        if (path.startsWith("DLFE/")) {
            path = path.substring(5);
        }
        if (path.length() <= 2) {
            return path;
        }
        String[] parts = StringUtil.split((String)path, (char)'/');
        StringBundler sb = new StringBundler(parts.length - 1);
        for (int i = 0; i < parts.length - 1; ++i) {
            sb.append(parts[i]);
        }
        String simpleName = parts[parts.length - 1];
        if (simpleName.startsWith(sb.toString())) {
            return simpleName;
        }
        return path;
    }
}

