/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.file.system;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.convert.documentlibrary.FileSystemStoreRootDirException;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.file.system.AdvancedFileSystemStore;
import com.liferay.portal.store.file.system.configuration.AdvancedFileSystemStoreConfiguration;
import com.liferay.portal.store.file.system.safe.file.name.SafeFileNameStore;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.portal.store.file.system.configuration.AdvancedFileSystemStoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class AdvancedFileSystemStoreRegister {
    private ServiceRegistration<Store> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        AdvancedFileSystemStoreConfiguration advancedFileSystemStoreConfiguration = (AdvancedFileSystemStoreConfiguration)ConfigurableUtil.createConfigurable(AdvancedFileSystemStoreConfiguration.class, properties);
        if (Validator.isBlank((String)advancedFileSystemStoreConfiguration.rootDir())) {
            throw new IllegalArgumentException("Advanced file system root directory is not set", (Throwable)new FileSystemStoreRootDirException());
        }
        this._serviceRegistration = bundleContext.registerService(Store.class, (Object)new SafeFileNameStore(new AdvancedFileSystemStore(advancedFileSystemStoreConfiguration)), MapUtil.singletonDictionary((Object)"store.type", (Object)AdvancedFileSystemStore.class.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }
}

