/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.file.system;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.file.system.configuration.FileSystemStoreConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FileSystemStore
implements Store {
    private final File _rootDir;

    public FileSystemStore(FileSystemStoreConfiguration fileSystemStoreConfiguration) {
        String path = fileSystemStoreConfiguration.rootDir();
        File rootDir = new File(path);
        if (!rootDir.isAbsolute()) {
            rootDir = new File(PropsUtil.get((String)"liferay.home"), path);
        }
        this._rootDir = rootDir;
        try {
            FileUtil.mkdirs((File)this._rootDir);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) {
        try {
            File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
            FileUtil.write((File)fileNameVersionFile, (InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (!dirNameDir.exists()) {
            return;
        }
        File parentFile = dirNameDir.getParentFile();
        FileUtil.deltree((File)dirNameDir);
        this._deleteEmptyAncestors(parentFile);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
        if (!fileNameVersionFile.exists()) {
            return;
        }
        File parentFile = fileNameVersionFile.getParentFile();
        fileNameVersionFile.delete();
        this._deleteEmptyAncestors(parentFile);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        if (Validator.isNull((String)versionLabel)) {
            versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        }
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
        try {
            return new FileInputStream(fileNameVersionFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, (Throwable)fileNotFoundException);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        File dirNameDir = this.getDirNameDir(companyId, repositoryId, dirName);
        if (!dirNameDir.exists()) {
            return new String[0];
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        this.getFileNames(fileNames, dirName, dirNameDir.getPath());
        Collections.sort(fileNames);
        return fileNames.toArray(new String[0]);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        File fileNameVersionFile;
        if (Validator.isNull((String)versionLabel)) {
            versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        }
        if (!(fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel)).exists()) {
            throw new NoSuchFileException(companyId, repositoryId, fileName);
        }
        return fileNameVersionFile.length();
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return StringPool.EMPTY_ARRAY;
        }
        String[] versions = FileUtil.listFiles((File)fileNameDir);
        Arrays.sort(versions, DLUtil::compareVersions);
        return versions;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        File fileNameVersionFile = this.getFileNameVersionFile(companyId, repositoryId, fileName, versionLabel);
        return fileNameVersionFile.exists();
    }

    protected File getDirNameDir(long companyId, long repositoryId, String dirName) {
        return this.getFileNameDir(companyId, repositoryId, dirName);
    }

    protected File getFileNameDir(long companyId, long repositoryId, String fileName) {
        return new File(this.getRepositoryDir(companyId, repositoryId), fileName);
    }

    protected void getFileNames(List<String> fileNames, String dirName, String path) {
        File file;
        Object[] pathDirNames = FileUtil.listDirs((String)path);
        if (ArrayUtil.isNotEmpty((Object[])pathDirNames)) {
            for (Object pathDirName : pathDirNames) {
                Object subdirName = null;
                subdirName = Validator.isBlank((String)dirName) ? pathDirName : dirName + "/" + (String)pathDirName;
                this.getFileNames(fileNames, (String)subdirName, path + "/" + (String)pathDirName);
            }
        } else if (!dirName.isEmpty() && (file = new File(path)).isDirectory()) {
            fileNames.add(dirName);
        }
    }

    protected File getFileNameVersionFile(long companyId, long repositoryId, String fileName, String version) {
        return new File(this.getFileNameDir(companyId, repositoryId, fileName), version);
    }

    protected String getHeadVersionLabel(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return "1.0";
        }
        String[] versionLabels = FileUtil.listFiles((File)fileNameDir);
        String headVersionLabel = "1.0";
        for (String versionLabel : versionLabels) {
            if (DLUtil.compareVersions((String)versionLabel, (String)headVersionLabel) <= 0) continue;
            headVersionLabel = versionLabel;
        }
        return headVersionLabel;
    }

    protected File getRepositoryDir(long companyId, long repositoryId) {
        File repositoryDir = new File(this._rootDir, companyId + "/" + repositoryId);
        if (!repositoryDir.exists()) {
            repositoryDir.mkdirs();
        }
        return repositoryDir;
    }

    private void _deleteEmptyAncestors(File file) {
        while (file != null) {
            if (!file.delete()) {
                return;
            }
            file = file.getParentFile();
        }
    }
}

