/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.file.system;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.convert.documentlibrary.FileSystemStoreRootDirException;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.file.system.FileSystemStore;
import com.liferay.portal.store.file.system.configuration.FileSystemStoreConfiguration;
import com.liferay.portal.store.file.system.safe.file.name.SafeFileNameStore;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.portal.store.file.system.configuration.FileSystemStoreConfiguration"}, service={})
public class FileSystemStoreRegister {
    private ServiceRegistration<Store> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        FileSystemStoreConfiguration fileSystemStoreConfiguration = (FileSystemStoreConfiguration)ConfigurableUtil.createConfigurable(FileSystemStoreConfiguration.class, properties);
        if (Validator.isBlank((String)fileSystemStoreConfiguration.rootDir())) {
            throw new IllegalArgumentException("File system root directory is not set", (Throwable)new FileSystemStoreRootDirException());
        }
        this._serviceRegistration = bundleContext.registerService(Store.class, (Object)new SafeFileNameStore(new FileSystemStore(fileSystemStoreConfiguration)), MapUtil.singletonDictionary((Object)"store.type", (Object)FileSystemStore.class.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }
}

