/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.file.system.safe.file.name;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class SafeFileNameStore
implements Store {
    private final Store _store;

    public SafeFileNameStore(Store store) {
        this._store = store;
    }

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName)) {
            this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        this._store.addFile(companyId, repositoryId, safeFileName, versionLabel, inputStream);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        if (!safeDirName.equals(dirName)) {
            this._store.deleteDirectory(companyId, repositoryId, dirName);
        }
        this._store.deleteDirectory(companyId, repositoryId, safeDirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName)) {
            this._store.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        this._store.deleteFile(companyId, repositoryId, safeFileName, versionLabel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (safeFileName.equals(fileName) || this._store.hasFile(companyId, repositoryId, safeFileName, versionLabel)) {
            return this._store.getFileAsStream(companyId, repositoryId, safeFileName, versionLabel);
        }
        return this._store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        HashSet<String> decodedFileNameSet = new HashSet<String>();
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        for (String fileName : this._store.getFileNames(companyId, repositoryId, safeDirName)) {
            decodedFileNameSet.add(FileUtil.decodeSafeFileName((String)fileName));
        }
        if (!safeDirName.equals(dirName)) {
            for (String fileName : this._store.getFileNames(companyId, repositoryId, dirName)) {
                decodedFileNameSet.add(FileUtil.decodeSafeFileName((String)fileName));
            }
        }
        Object[] decodedFilesNames = decodedFileNameSet.toArray(new String[0]);
        Arrays.sort(decodedFilesNames);
        return decodedFilesNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (safeFileName.equals(fileName) || this._store.hasFile(companyId, repositoryId, safeFileName, versionLabel)) {
            return this._store.getFileSize(companyId, repositoryId, safeFileName, versionLabel);
        }
        return this._store.getFileSize(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        HashSet versionSet = new HashSet();
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        Collections.addAll(versionSet, this._store.getFileVersions(companyId, repositoryId, safeFileName));
        if (!safeFileName.equals(fileName)) {
            Collections.addAll(versionSet, this._store.getFileVersions(companyId, repositoryId, fileName));
        }
        String[] versions = versionSet.toArray(new String[0]);
        Arrays.sort(versions, DLUtil::compareVersions);
        return versions;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (this._store.hasFile(companyId, repositoryId, safeFileName, versionLabel)) {
            return true;
        }
        if (safeFileName.equals(fileName)) {
            return false;
        }
        return this._store.hasFile(companyId, repositoryId, fileName, versionLabel);
    }
}

