/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.gcs;

import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageBatchResult;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.store.StoreArea;
import com.liferay.document.library.kernel.store.StoreAreaProcessor;
import com.liferay.document.library.kernel.util.comparator.VersionNumberComparator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.gcs.configuration.GCSStoreConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.threeten.bp.Duration;

@Component(configurationPid={"com.liferay.portal.store.gcs.configuration.GCSStoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"store.type=com.liferay.portal.store.gcs.GCSStore"}, service={Store.class})
public class GCSStore
implements Store {
    private static final int _EVICTED_BATCH_SIZE = 10;
    private static final long _PAGE_SIZE = 50L;
    private static final Log _log = LogFactoryUtil.getLog(GCSStore.class);
    private BucketInfo _bucketInfo;
    private Blob.BlobSourceOption _decryptBlobBlobSourceOption;
    private Storage.BlobSourceOption _decryptStorageBlobSourceOption;
    private Storage.BlobWriteOption _encryptStorageBlobWriteOption;
    private Storage _gcsStore;
    private volatile GCSStoreConfiguration _gcsStoreConfiguration;
    private GoogleCredentials _googleCredentials;
    private ServiceRegistration<StoreAreaProcessor> _serviceRegistration;

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) throws PortalException {
        if (this.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            this.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        String path = this._getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
        BlobInfo blobInfo = BlobInfo.newBuilder((BucketInfo)this._getBucketInfo(), (String)path).build();
        try (WriteChannel writeChannel = this._getWriteChannel(blobInfo);){
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)Channels.newOutputStream((WritableByteChannel)writeChannel));
        }
        catch (IOException ioException) {
            throw new PortalException("Unable to add file", (Throwable)ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        block7: {
            String path = this._getDirectoryKey(companyId, repositoryId, dirName);
            try {
                Page blobPage = this._gcsStore.list(this._gcsStoreConfiguration.bucketName(), new Storage.BlobListOption[]{Storage.BlobListOption.pageSize((long)50L), Storage.BlobListOption.prefix((String)path)});
                Iterable blobs = blobPage.iterateAll();
                ArrayList results = new ArrayList();
                StorageBatch storageBatch = this._gcsStore.batch();
                try {
                    blobs.forEach(blob -> results.add(this._deleteBlob((Blob)blob, storageBatch)));
                    if (results.isEmpty()) break block7;
                }
                catch (Throwable throwable) {
                    if (!results.isEmpty()) {
                        storageBatch.submit();
                        for (StorageBatchResult result : results) {
                            if (result != null && ((Boolean)result.get()).booleanValue()) continue;
                            _log.error((Object)StringBundler.concat((String[])new String[]{"Error deleting objects in bucket ", this._gcsStoreConfiguration.bucketName(), " at ", path}));
                            break;
                        }
                    }
                    throw throwable;
                }
                storageBatch.submit();
                for (StorageBatchResult result : results) {
                    if (result != null && ((Boolean)result.get()).booleanValue()) continue;
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Error deleting objects in bucket ", this._gcsStoreConfiguration.bucketName(), " at ", path}));
                    break;
                }
            }
            catch (StorageException storageException) {
                _log.error((Object)("Unable to delete " + path), (Throwable)storageException);
            }
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        this._gcsStore.delete(BlobId.of((String)this._gcsStoreConfiguration.bucketName(), (String)this._getHeadVersionLabel(companyId, repositoryId, fileName, versionLabel)));
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        Blob blob = this._gcsStore.get(BlobId.of((String)this._gcsStoreConfiguration.bucketName(), (String)this._getHeadVersionLabel(companyId, repositoryId, fileName, versionLabel)));
        if (blob == null) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
        }
        return Channels.newInputStream((ReadableByteChannel)this._getReadChannel(blob));
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        String prefix = StoreArea.getCurrentStoreAreaPath((long)companyId, (long)repositoryId, (String[])new String[0]) + "/";
        return (String[])TransformUtil.transform((Object[])this._getFilePaths(companyId, repositoryId, dirName), filePath -> filePath.substring(filePath.indexOf(prefix) + prefix.length(), filePath.lastIndexOf("/")), String.class);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        String headVersionLabel = this._getHeadVersionLabel(companyId, repositoryId, fileName, versionLabel);
        Blob blob = this._gcsStore.get(BlobId.of((String)this._gcsStoreConfiguration.bucketName(), (String)headVersionLabel));
        if (blob == null) {
            throw new NoSuchFileException("No file exists for " + headVersionLabel);
        }
        return blob.getSize();
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        return (String[])TransformUtil.transform((Object[])this._getFilePaths(companyId, repositoryId, fileName), path -> {
            String[] parts = StringUtil.split((String)path, (char)'/');
            return parts[parts.length - 1];
        }, String.class);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        String path = this._getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
        Page blobPage = this._gcsStore.list(this._gcsStoreConfiguration.bucketName(), new Storage.BlobListOption[]{Storage.BlobListOption.pageSize((long)1L), Storage.BlobListOption.prefix((String)path)});
        Iterable filesFoundIterable = blobPage.getValues();
        Iterator filesFoundIterator = filesFoundIterable.iterator();
        return filesFoundIterator.hasNext();
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._serviceRegistration = bundleContext.registerService(StoreAreaProcessor.class, (Object)new GCSStoreAreaProcessor(), MapUtil.singletonDictionary((Object)"store.type", (Object)"com.liferay.portal.store.gcs.GCSStore"));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        try {
            this._gcsStoreConfiguration = (GCSStoreConfiguration)ConfigurableUtil.createConfigurable(GCSStoreConfiguration.class, properties);
            this._initEncryption();
            this._initGCSStore();
        }
        catch (PortalException portalException) {
            throw new IllegalStateException("Unable to initialize GCS store", portalException);
        }
    }

    private StorageBatchResult<Boolean> _deleteBlob(Blob blob, StorageBatch storageBatch) {
        if (this._decryptStorageBlobSourceOption == null) {
            return storageBatch.delete(blob.getBlobId(), new Storage.BlobSourceOption[0]);
        }
        return storageBatch.delete(blob.getBlobId(), new Storage.BlobSourceOption[]{this._decryptStorageBlobSourceOption});
    }

    private BucketInfo _getBucketInfo() {
        if (this._bucketInfo == null) {
            this._bucketInfo = BucketInfo.newBuilder((String)this._gcsStoreConfiguration.bucketName()).build();
        }
        return this._bucketInfo;
    }

    private String _getDirectoryKey(long companyId, long repositoryId, String folderName) {
        return this._getFileKey(companyId, repositoryId, folderName);
    }

    private String _getFileKey(long companyId, long repositoryId, String fileName) {
        return StoreArea.getCurrentStoreAreaPath((long)companyId, (long)repositoryId, (String[])new String[]{fileName});
    }

    private String[] _getFilePaths(long companyId, long repositoryId, String dirName) {
        ArrayList filePaths = new ArrayList();
        Bucket bucket = this._gcsStore.get(this._gcsStoreConfiguration.bucketName(), new Storage.BucketGetOption[0]);
        String path = null;
        path = Validator.isNull((String)dirName) || dirName.equals("/") ? this._getRepositoryKey(companyId, repositoryId) : this._getDirectoryKey(companyId, repositoryId, dirName);
        Page blobPage = bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path)});
        Iterable blobs = blobPage.iterateAll();
        blobs.forEach(blob -> filePaths.add(blob.getName()));
        return filePaths.toArray(new String[0]);
    }

    private String _getFileVersionKey(long companyId, long repositoryId, String fileName, String versionLabel) {
        return StoreArea.getCurrentStoreAreaPath((long)companyId, (long)repositoryId, (String[])new String[]{fileName, versionLabel});
    }

    private String _getHeadVersionLabel(long companyId, long repositoryId, String fileName, String versionLabel) {
        if (Validator.isNotNull((String)versionLabel)) {
            return this._getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
        }
        String path = this._getFileKey(companyId, repositoryId, fileName);
        Object[] fileNames = this._getFilePaths(companyId, repositoryId, path);
        if (ArrayUtil.isEmpty((Object[])fileNames)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using default version for " + path));
            }
            return this._getFileVersionKey(companyId, repositoryId, fileName, "1.0");
        }
        List<Object> fileNamesList = Arrays.asList(fileNames);
        fileNamesList.sort((Comparator<Object>)new VersionNumberComparator());
        return (String)fileNamesList.get(fileNamesList.size() - 1);
    }

    private ReadChannel _getReadChannel(Blob blob) {
        if (this._decryptBlobBlobSourceOption == null) {
            return blob.reader(new Blob.BlobSourceOption[0]);
        }
        return blob.reader(new Blob.BlobSourceOption[]{this._decryptBlobBlobSourceOption});
    }

    private String _getRepositoryKey(long companyId, long repositoryId) {
        return StoreArea.getCurrentStoreAreaPath((long)companyId, (long)repositoryId, (String[])new String[0]);
    }

    private WriteChannel _getWriteChannel(BlobInfo blobInfo) {
        if (this._encryptStorageBlobWriteOption == null) {
            return this._gcsStore.writer(blobInfo, new Storage.BlobWriteOption[0]);
        }
        return this._gcsStore.writer(blobInfo, new Storage.BlobWriteOption[]{this._encryptStorageBlobWriteOption});
    }

    private void _initEncryption() {
        String aes256Key = this._gcsStoreConfiguration.aes256Key();
        if (Validator.isNull((String)aes256Key)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Files are not encrypted because the portal property \"dl.store.gcs.aes256.key\" is not set");
            }
            this._decryptBlobBlobSourceOption = null;
            this._decryptStorageBlobSourceOption = null;
            this._encryptStorageBlobWriteOption = null;
        } else {
            this._decryptBlobBlobSourceOption = Blob.BlobSourceOption.decryptionKey((String)aes256Key);
            this._decryptStorageBlobSourceOption = Storage.BlobSourceOption.decryptionKey((String)aes256Key);
            this._encryptStorageBlobWriteOption = Storage.BlobWriteOption.encryptionKey((String)aes256Key);
        }
    }

    private void _initGCSStore() throws PortalException {
        String serviceAccountKey = this._gcsStoreConfiguration.serviceAccountKey();
        try {
            if (Validator.isBlank((String)serviceAccountKey)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Using application default credentials because service account key was not set");
                }
                this._googleCredentials = ServiceAccountCredentials.getApplicationDefault();
            } else {
                this._googleCredentials = ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(serviceAccountKey.getBytes()));
            }
        }
        catch (IOException ioException) {
            throw new PortalException("Unable to authenticate with GCS", (Throwable)ioException);
        }
        StorageOptions storageOptions = ((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)this._googleCredentials)).setRetrySettings(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)this._gcsStoreConfiguration.initialRetryDelay())).setInitialRpcTimeout(Duration.ofMillis((long)this._gcsStoreConfiguration.initialRPCTimeout())).setJittered(this._gcsStoreConfiguration.retryJitter()).setMaxAttempts(this._gcsStoreConfiguration.maxRetryAttempts()).setMaxRetryDelay(Duration.ofMillis((long)this._gcsStoreConfiguration.maxRetryDelay())).setMaxRpcTimeout(Duration.ofMillis((long)this._gcsStoreConfiguration.maxRPCTimeout())).setRetryDelayMultiplier(this._gcsStoreConfiguration.retryDelayMultiplier()).setRpcTimeoutMultiplier(this._gcsStoreConfiguration.rpcTimeoutMultiplier()).build())).build();
        this._gcsStore = (Storage)storageOptions.getService();
    }

    private String _processStoreArea(long companyId, int evictionQuota, Predicate<Blob> predicate, String startOffset, StoreArea storeArea, TemporalAmount temporalAmount) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-174816")) {
            return "";
        }
        Bucket bucket = this._gcsStore.get(this._gcsStoreConfiguration.bucketName(), new Storage.BucketGetOption[0]);
        int evictedBlobQuota = Math.max(evictionQuota, 1);
        int evictedBlobsCount = 0;
        Instant instant = Instant.now();
        String lastVisitedBlobName = startOffset;
        StorageBatch storageBatch = this._gcsStore.batch();
        int pageSize = Math.max(evictedBlobQuota * 2, 10);
        for (int visitedPageLimit = Math.max(evictedBlobQuota / 10, 10); evictedBlobQuota > 0 && visitedPageLimit > 0; --visitedPageLimit) {
            boolean emptyPage = true;
            Page blobPage = bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID, Storage.BlobField.NAME, Storage.BlobField.UPDATED}), Storage.BlobListOption.pageSize((long)pageSize), Storage.BlobListOption.prefix((String)storeArea.getPath(companyId)), Storage.BlobListOption.startOffset((String)lastVisitedBlobName)});
            for (Blob blob : blobPage.getValues()) {
                Instant updateTimeInstant = Instant.ofEpochMilli(blob.getUpdateTime());
                Instant evictionInstant = updateTimeInstant.plus(temporalAmount);
                if (evictionInstant.isBefore(instant) && predicate.test(blob)) {
                    storageBatch.delete(blob.getBlobId(), new Storage.BlobSourceOption[0]);
                    --evictedBlobQuota;
                    ++evictedBlobsCount;
                }
                emptyPage = false;
                lastVisitedBlobName = blob.getName();
            }
            if (evictedBlobsCount >= 10) {
                storageBatch.submit();
                evictedBlobsCount = 0;
                storageBatch = this._gcsStore.batch();
            }
            if (!emptyPage) continue;
            lastVisitedBlobName = "";
            break;
        }
        if (evictedBlobsCount > 0) {
            storageBatch.submit();
        }
        return lastVisitedBlobName;
    }

    private class GCSStoreAreaProcessor
    implements StoreAreaProcessor {
        private GCSStoreAreaProcessor() {
        }

        public String cleanUpDeletedStoreArea(long companyId, int deletionQuota, Predicate<String> predicate, String startOffset, TemporalAmount temporalAmount) {
            return GCSStore.this._processStoreArea(companyId, deletionQuota, blob -> predicate.test(blob.getName()), startOffset, StoreArea.DELETED, temporalAmount);
        }

        public String cleanUpNewStoreArea(long companyId, int evictionQuota, Predicate<String> predicate, String startOffset, TemporalAmount temporalAmount) {
            return GCSStore.this._processStoreArea(companyId, evictionQuota, blob -> {
                if (predicate.test(blob.getName())) {
                    return this.copy(blob.getName(), StoreArea.NEW.relocate(blob.getName(), StoreArea.DELETED));
                }
                return this.copy(blob.getName(), StoreArea.NEW.relocate(blob.getName(), StoreArea.LIVE));
            }, startOffset, StoreArea.NEW, temporalAmount);
        }

        public boolean copy(String sourceFileName, String destinationFileName) {
            try {
                if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-174816")) {
                    return true;
                }
                CopyWriter copyWriter = GCSStore.this._gcsStore.copy(Storage.CopyRequest.newBuilder().setSource(GCSStore.this._gcsStoreConfiguration.bucketName(), sourceFileName).setTarget(BlobId.of((String)GCSStore.this._gcsStoreConfiguration.bucketName(), (String)destinationFileName)).build());
                while (!copyWriter.isDone()) {
                    copyWriter.copyChunk();
                }
                return true;
            }
            catch (StorageException storageException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Throwable)storageException);
                }
                return false;
            }
        }

        public boolean copyDirectory(long companyId, long repositoryId, String dirName, StoreArea[] sourceStoreAreas, StoreArea destinationStoreArea) {
            try {
                if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-174816")) {
                    return true;
                }
                for (StoreArea sourceStoreArea : sourceStoreAreas) {
                    String[] filePaths;
                    for (String filePath : filePaths = (String[])StoreArea.withStoreArea((StoreArea)sourceStoreArea, () -> GCSStore.this._getFilePaths(companyId, repositoryId, dirName))) {
                        this.copy(filePath, sourceStoreArea.relocate(filePath, destinationStoreArea));
                    }
                }
                return true;
            }
            catch (StorageException storageException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Throwable)storageException);
                }
                return false;
            }
        }
    }
}

