/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.jcr;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.memory.FinalizeAction;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.store.jcr.JCRFactory;
import com.liferay.portal.store.jcr.JCRSessionInvocationHandler;
import com.liferay.portal.store.jcr.configuration.JCRStoreConfiguration;
import com.liferay.portal.store.jcr.jackrabbit.JCRFactoryImpl;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class JCRFactoryWrapper {
    private static final ThreadLocal<Map<String, Session>> _sessions = new CentralizedThreadLocal(JCRFactoryWrapper.class + "._sessions", HashMap::new);
    private final JCRFactory _jcrFactory;
    private final JCRStoreConfiguration _jcrStoreConfiguration;

    public JCRFactoryWrapper(JCRStoreConfiguration jcrStoreConfiguration) throws RepositoryException {
        this._jcrStoreConfiguration = jcrStoreConfiguration;
        this._jcrFactory = new JCRFactoryImpl(jcrStoreConfiguration);
    }

    public void closeSession(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    public Session createSession() throws RepositoryException {
        return this.createSession(null);
    }

    public Session createSession(String workspaceName) throws RepositoryException {
        if (workspaceName == null) {
            workspaceName = this._jcrStoreConfiguration.workspaceName();
        }
        if (!this._jcrStoreConfiguration.wrapSession()) {
            JCRFactory jcrFactory = this.getJCRFactory();
            return jcrFactory.createSession(workspaceName);
        }
        Map<String, Session> sessions = _sessions.get();
        Session session = sessions.get(workspaceName);
        if (session != null) {
            return session;
        }
        JCRFactory jcrFactory = this.getJCRFactory();
        Session jcrSession = jcrFactory.createSession(workspaceName);
        JCRSessionInvocationHandler jcrSessionInvocationHandler = new JCRSessionInvocationHandler(jcrSession);
        Object sessionProxy = ProxyUtil.newProxyInstance((ClassLoader)ClassLoaderUtil.getClassLoader(this.getClass()), (Class[])new Class[]{Map.class, Session.class}, (InvocationHandler)jcrSessionInvocationHandler);
        FinalizeManager.register((Object)sessionProxy, (FinalizeAction)jcrSessionInvocationHandler, (FinalizeManager.ReferenceFactory)FinalizeManager.PHANTOM_REFERENCE_FACTORY);
        session = (Session)sessionProxy;
        sessions.put(workspaceName, session);
        return session;
    }

    public JCRFactory getJCRFactory() {
        return this._jcrFactory;
    }

    public void initialize() throws RepositoryException {
        JCRFactory jcrFactory = this.getJCRFactory();
        jcrFactory.initialize();
    }

    public void prepare() throws RepositoryException {
        JCRFactory jcrFactory = this.getJCRFactory();
        jcrFactory.prepare();
    }

    public void shutdown() {
        JCRFactory jcrFactory = this.getJCRFactory();
        jcrFactory.shutdown();
    }
}

