/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.jcr;

import com.liferay.petra.memory.FinalizeAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Session;

public class JCRSessionInvocationHandler
implements FinalizeAction,
InvocationHandler {
    private static final Log _log = LogFactoryUtil.getLog(JCRSessionInvocationHandler.class);
    private final Map<String, Binary> _binaries = new HashMap<String, Binary>();
    private final Session _session;

    public JCRSessionInvocationHandler(Session session) {
        this._session = session;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Starting session " + this._session));
        }
    }

    public void doFinalize(Reference<?> reference) {
        for (Map.Entry<String, Binary> entry : this._binaries.entrySet()) {
            Binary binary = entry.getValue();
            binary.dispose();
        }
        this._session.logout();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("logout")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping logout for session " + this._session));
            }
            return null;
        }
        if (methodName.equals("put")) {
            String key = (String)arguments[0];
            Binary binary = (Binary)arguments[1];
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Tracking binary ", key, " for session ", String.valueOf(this._session)}));
            }
            this._binaries.put(key, binary);
            return null;
        }
        try {
            return method.invoke((Object)this._session, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }
}

