/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.jcr;

import com.liferay.document.library.kernel.exception.DuplicateFileException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.BaseStore;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.jcr.JCRFactoryWrapper;
import com.liferay.portal.store.jcr.configuration.JCRStoreConfiguration;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Deprecated
@Component(configurationPid={"com.liferay.portal.store.jcr.configuration.JCRStoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"store.type=com.liferay.portal.store.jcr.JCRStore"}, service={Store.class})
public class JCRStore
extends BaseStore {
    private static final Log _log = LogFactoryUtil.getLog(JCRStore.class);
    private JCRFactoryWrapper _jcrFactoryWrapper;
    private volatile JCRStoreConfiguration _jcrStoreConfiguration;

    public void addDirectory(long companyId, long repositoryId, String dirName) {
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            if (repositoryNode.hasNode(dirName)) {
                return;
            }
            String[] dirNameArray = StringUtil.split((String)dirName, (char)'/');
            Node dirNode = repositoryNode;
            for (String nodeName : dirNameArray) {
                if (!Validator.isNotNull((String)nodeName)) continue;
                dirNode = dirNode.hasNode(nodeName) ? dirNode.getNode(nodeName) : dirNode.addNode(nodeName, "nt:folder");
            }
            session.save();
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws DuplicateFileException {
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Workspace workspace = session.getWorkspace();
            VersionManager versionManager = workspace.getVersionManager();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            if (fileName.contains("/")) {
                String path = fileName.substring(0, fileName.lastIndexOf("/"));
                fileName = fileName.substring(path.length() + 1);
                repositoryNode = this.getFolderNode(repositoryNode, path);
            }
            if (repositoryNode.hasNode(fileName)) {
                throw new DuplicateFileException(companyId, repositoryId, fileName);
            }
            Node fileNode = repositoryNode.addNode(fileName, "nt:file");
            Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
            contentNode.addMixin("mix:versionable");
            contentNode.setProperty("jcr:mimeType", "text/plain");
            ValueFactory valueFactory = session.getValueFactory();
            Binary binary = valueFactory.createBinary(is);
            contentNode.setProperty("jcr:data", binary);
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            session.save();
            Version version = versionManager.checkin(contentNode.getPath());
            VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
            versionHistory.addVersionLabel(version.getName(), "1.0", false);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public void checkRoot(long companyId) {
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            this.getRootNode(session, companyId);
            session.save();
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        block9: {
            Session session = null;
            try {
                session = this._jcrFactoryWrapper.createSession();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                if (dirName.equals("/")) {
                    dirName = ".";
                }
                Node dirNode = repositoryNode.getNode(dirName);
                dirNode.remove();
                session.save();
            }
            catch (PathNotFoundException pnfe) {
                this.logFailedDeletion(companyId, repositoryId, dirName, (Exception)((Object)pnfe));
            }
            catch (RepositoryException re) {
                String message = StringUtil.toLowerCase((String)GetterUtil.getString((String)re.getMessage()));
                if (message.contains("failed to resolve path")) {
                    this.logFailedDeletion(companyId, repositoryId, dirName, (Exception)((Object)re));
                    break block9;
                }
                throw new SystemException((Throwable)re);
            }
            finally {
                this._jcrFactoryWrapper.closeSession(session);
            }
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) {
        Node contentNode;
        Node fileNode;
        Node repositoryNode;
        Node rootNode;
        VersionManager versionManager;
        Workspace workspace;
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            workspace = session.getWorkspace();
            versionManager = workspace.getVersionManager();
            rootNode = this.getRootNode(session, companyId);
            repositoryNode = this.getFolderNode(rootNode, repositoryId);
            fileNode = repositoryNode.getNode(fileName);
            contentNode = fileNode.getNode("jcr:content");
            versionManager.checkout(contentNode.getPath());
            contentNode.setProperty("jcr:mimeType", "text/plain");
            contentNode.setProperty("jcr:data", "");
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            session.save();
            Version version = versionManager.checkin(contentNode.getPath());
            VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
            versionHistory.addVersionLabel(version.getName(), "0.0", false);
        }
        catch (PathNotFoundException pnfe) {
            this.logFailedDeletion(companyId, repositoryId, fileName, (Exception)((Object)pnfe));
            return;
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
        try {
            session = this._jcrFactoryWrapper.createSession();
            workspace = session.getWorkspace();
            versionManager = workspace.getVersionManager();
            rootNode = this.getRootNode(session, companyId);
            repositoryNode = this.getFolderNode(rootNode, repositoryId);
            fileNode = repositoryNode.getNode(fileName);
            contentNode = fileNode.getNode("jcr:content");
            VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
            VersionIterator itr = versionHistory.getAllVersions();
            while (itr.hasNext()) {
                Version version = itr.nextVersion();
                if (itr.getPosition() == itr.getSize()) break;
                if (StringUtils.equals((String)"jcr:rootVersion", (String)version.getName())) continue;
                versionHistory.removeVersion(version.getName());
            }
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            this.logFailedDeletion(companyId, repositoryId, fileName, (Exception)((Object)pnfe));
            return;
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
        try {
            session = this._jcrFactoryWrapper.createSession();
            Node rootNode2 = this.getRootNode(session, companyId);
            Node repositoryNode2 = this.getFolderNode(rootNode2, repositoryId);
            Node fileNode2 = repositoryNode2.getNode(fileName);
            fileNode2.remove();
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            this.logFailedDeletion(companyId, repositoryId, fileName, (Exception)((Object)pnfe));
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Workspace workspace = session.getWorkspace();
            VersionManager versionManager = workspace.getVersionManager();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node fileNode = repositoryNode.getNode(fileName);
            Node contentNode = fileNode.getNode("jcr:content");
            VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
            if (!versionHistory.hasVersionLabel(versionLabel)) {
                this.logFailedDeletion(companyId, repositoryId, fileName, versionLabel);
            }
            Version version = versionHistory.getVersionByLabel(versionLabel);
            Version linearPredecessorVersion = version.getLinearPredecessor();
            if (version.getLinearSuccessor() == null) {
                Version restoreVersion = linearPredecessorVersion;
                if (Objects.equals("jcr:rootVersion", linearPredecessorVersion.getName())) {
                    versionManager.checkout(contentNode.getPath());
                    restoreVersion = versionManager.checkin(contentNode.getPath());
                }
                versionManager.restore(restoreVersion, true);
            }
            versionHistory.removeVersion(version.getName());
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            this.logFailedDeletion(companyId, repositoryId, fileName, versionLabel, (Exception)((Object)pnfe));
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Node contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, versionLabel);
            Property property = contentNode.getProperty("jcr:data");
            Value value = property.getValue();
            Binary binary = value.getBinary();
            if (session instanceof Map) {
                Map mapSession = (Map)session;
                mapSession.put(fileName, binary);
            }
            InputStream inputStream = binary.getStream();
            return inputStream;
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId) {
        ArrayList<String> fileNames = new ArrayList<String>();
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            NodeIterator itr = repositoryNode.getNodes();
            while (itr.hasNext()) {
                Node node = itr.nextNode();
                NodeType primaryNodeType = node.getPrimaryNodeType();
                String primaryNodeTypeName = primaryNodeType.getName();
                if (primaryNodeTypeName.equals("nt:folder")) {
                    this.doGetFileNames(fileNames, node.getName(), node);
                    continue;
                }
                if (!primaryNodeTypeName.equals("nt:file")) continue;
                fileNames.add(node.getName());
            }
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node dirNode = repositoryNode.getNode(dirName);
            this.doGetFileNames(fileNames, dirName, dirNode);
        }
        catch (PathNotFoundException pnfe) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws NoSuchFileException {
        long size = 0L;
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Node contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, "");
            Property property = contentNode.getProperty("jcr:data");
            size = property.getLength();
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
        return size;
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) {
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            repositoryNode.getNode(dirName);
            boolean bl = true;
            return bl;
        }
        catch (PathNotFoundException pnfe) {
            boolean bl = false;
            return bl;
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        try {
            this.getFileContentNode(companyId, repositoryId, fileName, versionLabel);
        }
        catch (NoSuchFileException nsfe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsfe, (Throwable)nsfe);
            }
            return false;
        }
        return true;
    }

    public void move(String srcDir, String destDir) {
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            session.move(srcDir, destDir);
            session.save();
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws DuplicateFileException, NoSuchFileException {
        if (repositoryId == newRepositoryId) {
            throw new DuplicateFileException(companyId, newRepositoryId, fileName);
        }
        Session session = null;
        try {
            Node newRepositoryNode;
            session = this._jcrFactoryWrapper.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            if (fileName.contains("/")) {
                String path = fileName.substring(0, fileName.lastIndexOf("/"));
                fileName = fileName.substring(path.length() + 1);
                repositoryNode = this.getFolderNode(repositoryNode, path);
            }
            if ((newRepositoryNode = this.getFolderNode(rootNode, newRepositoryId)).hasNode(fileName)) {
                throw new DuplicateFileException(companyId, newRepositoryId, fileName);
            }
            Node fileNode = repositoryNode.getNode(fileName);
            Node contentNode = fileNode.getNode("jcr:content");
            String contentNodePath = contentNode.getPath();
            Node newFileNode = newRepositoryNode.addNode(fileName, "nt:file");
            String newContentNodePath = newFileNode.getPath().concat("/").concat("jcr:content");
            session.move(contentNodePath, newContentNodePath);
            fileNode.remove();
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, (Throwable)pnfe);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws DuplicateFileException, NoSuchFileException {
        if (fileName.equals(newFileName)) {
            throw new DuplicateFileException(companyId, repositoryId, newFileName);
        }
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            if (fileName.contains("/")) {
                String path = fileName.substring(0, fileName.lastIndexOf("/"));
                fileName = fileName.substring(path.length() + 1);
                repositoryNode = this.getFolderNode(repositoryNode, path);
            }
            if (repositoryNode.hasNode(newFileName)) {
                throw new DuplicateFileException(companyId, repositoryId, newFileName);
            }
            Node fileNode = repositoryNode.getNode(fileName);
            Node contentNode = fileNode.getNode("jcr:content");
            String contentNodePath = contentNode.getPath();
            Node newFileNode = repositoryNode.addNode(newFileName, "nt:file");
            String newContentNodePath = newFileNode.getPath().concat("/").concat("jcr:content");
            session.move(contentNodePath, newContentNodePath);
            fileNode.remove();
            session.save();
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, (Throwable)pnfe);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws DuplicateFileException, NoSuchFileException {
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            Workspace workspace = session.getWorkspace();
            VersionManager versionManager = workspace.getVersionManager();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            if (fileName.contains("/")) {
                String path = fileName.substring(0, fileName.lastIndexOf("/"));
                fileName = fileName.substring(path.length() + 1);
                repositoryNode = this.getFolderNode(repositoryNode, path);
            }
            Node fileNode = repositoryNode.getNode(fileName);
            Node contentNode = fileNode.getNode("jcr:content");
            versionManager.checkout(contentNode.getPath());
            contentNode.setProperty("jcr:mimeType", "text/plain");
            ValueFactory valueFactory = session.getValueFactory();
            Binary binary = valueFactory.createBinary(is);
            contentNode.setProperty("jcr:data", binary);
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            session.save();
            Version version = versionManager.checkin(contentNode.getPath());
            VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
            if (versionHistory.hasVersionLabel(versionLabel)) {
                throw new DuplicateFileException(companyId, repositoryId, fileName, versionLabel);
            }
            versionHistory.addVersionLabel(version.getName(), versionLabel, this._jcrStoreConfiguration.moveVersionLabels());
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel, (Throwable)pnfe);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws RepositoryException {
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(3);
            sb.append("Liferay is configured via the portal property ");
            sb.append("\"dl.store.impl\" to use JCR to persist documents. ");
            sb.append("JCR is deprecated and is not supported.");
            _log.warn((Object)sb.toString());
        }
        this._jcrStoreConfiguration = (JCRStoreConfiguration)ConfigurableUtil.createConfigurable(JCRStoreConfiguration.class, properties);
        try {
            this._jcrFactoryWrapper = new JCRFactoryWrapper(this._jcrStoreConfiguration);
            this._jcrFactoryWrapper.prepare();
            if (this._jcrStoreConfiguration.initializeOnStartup()) {
                this._jcrFactoryWrapper.initialize();
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate() {
        this._jcrFactoryWrapper.shutdown();
        this._jcrFactoryWrapper = null;
    }

    protected void doGetFileNames(List<String> fileNames, String dirName, Node node) throws RepositoryException {
        NodeType primaryNodeType = node.getPrimaryNodeType();
        String primaryNodeTypeName = primaryNodeType.getName();
        if (primaryNodeTypeName.equals("nt:folder")) {
            NodeIterator itr = node.getNodes();
            while (itr.hasNext()) {
                Node curNode = itr.nextNode();
                String subdirName = null;
                subdirName = Validator.isBlank((String)dirName) ? curNode.getName() : dirName + "/" + curNode.getName();
                this.doGetFileNames(fileNames, subdirName, curNode);
            }
        } else if (primaryNodeTypeName.equals("nt:file")) {
            fileNames.add(dirName);
        }
    }

    protected Node getFileContentNode(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        Node contentNode = null;
        Session session = null;
        try {
            session = this._jcrFactoryWrapper.createSession();
            contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, versionLabel);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            this._jcrFactoryWrapper.closeSession(session);
        }
        return contentNode;
    }

    protected Node getFileContentNode(Session session, long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        Node contentNode = null;
        try {
            Workspace workspace = session.getWorkspace();
            VersionManager versionManager = workspace.getVersionManager();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node fileNode = repositoryNode.getNode(fileName);
            contentNode = fileNode.getNode("jcr:content");
            if (Validator.isNotNull((String)versionLabel)) {
                VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
                if (!versionHistory.hasVersionLabel(versionLabel)) {
                    throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
                }
                Version version = versionHistory.getVersionByLabel(versionLabel);
                contentNode = version.getNode("jcr:frozenNode");
            }
        }
        catch (PathNotFoundException pnfe) {
            throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel, (Throwable)pnfe);
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        return contentNode;
    }

    protected Node getFolderNode(Node node, long name) throws RepositoryException {
        return this.getFolderNode(node, String.valueOf(name));
    }

    protected Node getFolderNode(Node node, String name) throws RepositoryException {
        if (name.contains("/")) {
            String[] nameParts = name.split("/", 2);
            node = this.getFolderNode(node, nameParts[0]);
            return this.getFolderNode(node, nameParts[1]);
        }
        Node folderNode = null;
        folderNode = node.hasNode(name) ? node.getNode(name) : node.addNode(name, "nt:folder");
        return folderNode;
    }

    protected Node getRootNode(Session session, long companyId) throws RepositoryException {
        Node companyNode = this.getFolderNode(session.getRootNode(), companyId);
        return this.getFolderNode(companyNode, this._jcrStoreConfiguration.nodeDocumentlibrary());
    }

    @Modified
    protected void modified(Map<String, Object> properties) throws RepositoryException {
        this.deactivate();
        this.activate(properties);
    }
}

