/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.jcr.jackrabbit;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.store.jcr.JCRFactory;
import com.liferay.portal.store.jcr.configuration.JCRStoreConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.TransientRepository;

public class JCRFactoryImpl
implements JCRFactory {
    private static final Log _log = LogFactoryUtil.getLog(JCRFactoryImpl.class);
    private final JCRStoreConfiguration _jcrStoreConfiguration;
    private final TransientRepository _transientRepository;

    public JCRFactoryImpl(JCRStoreConfiguration jcrStoreConfiguration) throws RepositoryException {
        this._jcrStoreConfiguration = jcrStoreConfiguration;
        try {
            this._transientRepository = new TransientRepository(this._jcrStoreConfiguration.jackrabbitConfigFilePath(), this._jcrStoreConfiguration.jackrabbitRepositoryHome());
        }
        catch (Exception e) {
            _log.error((Object)"Problem initializing Jackrabbit JCR", (Throwable)e);
            throw e;
        }
        if (_log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(4);
            sb.append("Jackrabbit JCR intialized with config file path ");
            sb.append(this._jcrStoreConfiguration.jackrabbitConfigFilePath());
            sb.append(" and repository home ");
            sb.append(this._jcrStoreConfiguration.jackrabbitRepositoryHome());
            _log.info((Object)sb.toString());
        }
    }

    @Override
    public Session createSession(String workspaceName) throws RepositoryException {
        String credentialsPassword = this._jcrStoreConfiguration.jackrabbitCredentialsPassword();
        SimpleCredentials credentials = new SimpleCredentials(this._jcrStoreConfiguration.jackrabbitCredentialsUsername(), credentialsPassword.toCharArray());
        Session session = null;
        try {
            session = this._transientRepository.login((Credentials)credentials, workspaceName);
        }
        catch (RepositoryException re) {
            _log.error((Object)("Unable to login to the workspace " + workspaceName));
            throw re;
        }
        return session;
    }

    @Override
    public void initialize() throws RepositoryException {
        Session session = null;
        try {
            session = this.createSession(null);
        }
        catch (RepositoryException re) {
            _log.error((Object)"Unable to initialize Jackrabbit");
            throw re;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void prepare() throws RepositoryException {
        try {
            File jackrabbitConfigFile = new File(this._jcrStoreConfiguration.jackrabbitConfigFilePath());
            if (jackrabbitConfigFile.exists() && jackrabbitConfigFile.isFile()) {
                return;
            }
            String path = this._jcrStoreConfiguration.jackrabbitRepositoryRoot();
            File repositoryRoot = new File(path);
            if (!repositoryRoot.isAbsolute()) {
                path = PropsUtil.get((String)"liferay.home") + "/" + path;
            }
            FileUtil.mkdirs((String)path);
            File tempFile = new File(SystemProperties.get((String)"java.io.tmpdir") + File.separator + Time.getTimestamp());
            String repositoryXmlPath = "com/liferay/portal/store/jcr/jackrabbit/dependencies/repository-ext.xml";
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader.getResource(repositoryXmlPath) == null) {
                repositoryXmlPath = "com/liferay/portal/store/jcr/jackrabbit/dependencies/repository.xml";
            }
            FileUtil.write((File)tempFile, (InputStream)classLoader.getResourceAsStream(repositoryXmlPath));
            FileUtil.copyFile((File)tempFile, (File)jackrabbitConfigFile);
            tempFile.delete();
        }
        catch (IOException ioe) {
            _log.error((Object)"Unable to prepare Jackrabbit directory");
            throw new RepositoryException((Throwable)ioe);
        }
    }

    @Override
    public void shutdown() {
        this._transientRepository.shutdown();
    }
}

