/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.s3;

import com.liferay.petra.io.unsync.UnsyncFilterInputStream;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.store.s3.S3KeyTransformer;
import com.liferay.portal.store.s3.configuration.S3StoreConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.store.s3.configuration.S3StoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={S3FileCache.class})
public class S3FileCache {
    private static final String _CACHE_DIR_NAME = "/liferay/s3";
    private static final String _CACHE_DIR_PATTERN = "/yyyy/MM/dd/HH/";
    private static final Log _log = LogFactoryUtil.getLog(S3FileCache.class);
    private AtomicInteger _cacheDirCleanUpExpunge;
    private AtomicInteger _cacheDirCleanUpFrequency;
    private int _calledCleanUpCacheFilesCount;
    private S3KeyTransformer _s3KeyTransformer;
    private volatile S3StoreConfiguration _s3StoreConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpCacheFiles() {
        ++this._calledCleanUpCacheFilesCount;
        if (this._calledCleanUpCacheFilesCount < this._cacheDirCleanUpFrequency.intValue()) {
            return;
        }
        S3FileCache s3FileCache = this;
        synchronized (s3FileCache) {
            if (this._calledCleanUpCacheFilesCount == 0) {
                return;
            }
            this._calledCleanUpCacheFilesCount = 0;
            Path cacheDirPath = Paths.get(this.getCacheDirName(), new String[0]);
            long lastModified = System.currentTimeMillis();
            this.cleanUpCacheFiles(cacheDirPath, lastModified -= (long)this._cacheDirCleanUpExpunge.intValue() * 86400000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getCacheFileInputStream(final Closeable closeable, String fileName, Supplier<InputStream> inputStreamSupplier, Date lastModifiedDate) throws IOException {
        StringBundler sb = new StringBundler(4);
        sb.append(this.getCacheDirName());
        sb.append(DateUtil.getCurrentDate((String)_CACHE_DIR_PATTERN, (Locale)LocaleUtil.getDefault()));
        sb.append(this._s3KeyTransformer.getNormalizedFileName(fileName));
        sb.append(lastModifiedDate.getTime());
        String cacheFileName = sb.toString();
        File cacheFile = new File(cacheFileName);
        if (cacheFile.exists() && cacheFile.lastModified() >= lastModifiedDate.getTime()) {
            closeable.close();
            return new FileInputStream(cacheFile);
        }
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            InputStream s3InputStream = inputStreamSupplier.get();
            if (s3InputStream == null) {
                throw new IOException("S3 object input stream is null");
            }
            return new UnsyncFilterInputStream(s3InputStream){

                public void close() throws IOException {
                    super.close();
                    closeable.close();
                }
            };
        }
        try (InputStream inputStream = inputStreamSupplier.get();){
            if (inputStream == null) {
                throw new IOException("S3 object input stream is null");
            }
            FileUtil.mkdirs((File)cacheFile.getParentFile());
            try (FileOutputStream outputStream = new FileOutputStream(cacheFile);){
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
        finally {
            closeable.close();
        }
        return new FileInputStream(cacheFile);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._s3StoreConfiguration = (S3StoreConfiguration)ConfigurableUtil.createConfigurable(S3StoreConfiguration.class, properties);
        this._cacheDirCleanUpExpunge = new AtomicInteger(this._s3StoreConfiguration.cacheDirCleanUpExpunge());
        this._cacheDirCleanUpFrequency = new AtomicInteger(this._s3StoreConfiguration.cacheDirCleanUpFrequency());
    }

    protected void cleanUpCacheFiles(Path cacheDirPath, final long lastModified) {
        if (Files.notExists(cacheDirPath, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(cacheDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dirPath, IOException ioException) throws IOException {
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath);){
                        Iterator<Path> iterator = directoryStream.iterator();
                        if (!iterator.hasNext()) {
                            Files.delete(dirPath);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    FileTime fileTime = Files.getLastModifiedTime(filePath, new LinkOption[0]);
                    if (fileTime.toMillis() < lastModified) {
                        Files.delete(filePath);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to clean up cache files for " + cacheDirPath), (Throwable)ioException);
        }
    }

    @Deactivate
    protected void deactivate() {
        File cacheDir = new File(this.getCacheDirName());
        boolean deleted = cacheDir.delete();
        if (!deleted && _log.isWarnEnabled()) {
            _log.warn((Object)("Unable to delete " + this.getCacheDirName()));
        }
    }

    protected String getCacheDirName() {
        return SystemProperties.get((String)"java.io.tmpdir") + _CACHE_DIR_NAME;
    }

    @Reference(unbind="-")
    protected void setS3KeyTransformer(S3KeyTransformer s3KeyTransformer) {
        this._s3KeyTransformer = s3KeyTransformer;
    }
}

