/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.s3;

import com.amazonaws.services.s3.transfer.TransferManager;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.store.s3.S3Store;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class AbortedMultipartUploadCleaner {
    @Reference(unbind="-")
    private SchedulerEngineHelper _schedulerEngineHelper;
    private ServiceTracker<S3Store, MessageListener> _serviceTracker;
    @Reference(unbind="-")
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        this._serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter(StringBundler.concat((String[])new String[]{"(&(", "objectClass", "=", Store.class.getName(), ")(store.type=", S3Store.class.getName(), "))"})), (ServiceTrackerCustomizer)new S3StoreServiceTrackerCustomizer(bundleContext, this._schedulerEngineHelper, this._triggerFactory));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private static class S3StoreServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<S3Store, MessageListener> {
        private final BundleContext _bundleContext;
        private final SchedulerEngineHelper _schedulerEngineHelper;
        private final TriggerFactory _triggerFactory;

        public MessageListener addingService(ServiceReference<S3Store> serviceReference) {
            AbortedMultipartUploadMessageListener messageListener = new AbortedMultipartUploadMessageListener((S3Store)this._bundleContext.getService(serviceReference));
            Class<?> clazz = this.getClass();
            String className = clazz.getName();
            Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, 1, TimeUnit.DAY);
            SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
            this._schedulerEngineHelper.register((MessageListener)messageListener, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
            return messageListener;
        }

        public void modifiedService(ServiceReference<S3Store> serviceReference, MessageListener messageListener) {
        }

        public void removedService(ServiceReference<S3Store> serviceReference, MessageListener messageListener) {
            this._schedulerEngineHelper.unregister(messageListener);
        }

        private S3StoreServiceTrackerCustomizer(BundleContext bundleContext, SchedulerEngineHelper schedulerEngineHelper, TriggerFactory triggerFactory) {
            this._bundleContext = bundleContext;
            this._schedulerEngineHelper = schedulerEngineHelper;
            this._triggerFactory = triggerFactory;
        }
    }

    private static class AbortedMultipartUploadMessageListener
    extends BaseMessageListener {
        private final S3Store _s3Store;

        protected void doReceive(Message message) throws Exception {
            TransferManager transferManager = this._s3Store.getTransferManager();
            transferManager.abortMultipartUploads(this._s3Store.getBucketName(), this._computeStartDate());
        }

        private AbortedMultipartUploadMessageListener(S3Store s3Store) {
            this._s3Store = s3Store;
        }

        private Date _computeStartDate() {
            Date date = new Date();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            LocalDateTime previousDayLocalDateTime = localDateTime.minus(1L, ChronoUnit.DAYS);
            ZonedDateTime zonedDateTime = previousDayLocalDateTime.atZone(ZoneId.systemDefault());
            return Date.from(zonedDateTime.toInstant());
        }
    }
}

