/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.s3;

import com.ibm.cloud.objectstorage.AmazonClientException;
import com.ibm.cloud.objectstorage.AmazonServiceException;
import com.ibm.cloud.objectstorage.ClientConfiguration;
import com.ibm.cloud.objectstorage.Protocol;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.AWSStaticCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.BasicAWSCredentials;
import com.ibm.cloud.objectstorage.auth.DefaultAWSCredentialsProviderChain;
import com.ibm.cloud.objectstorage.client.builder.AwsClientBuilder;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3ClientBuilder;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteObjectsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectMetadataRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListObjectsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectListing;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectMetadata;
import com.ibm.cloud.objectstorage.services.s3.model.PutObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.S3Object;
import com.ibm.cloud.objectstorage.services.s3.model.S3ObjectSummary;
import com.ibm.cloud.objectstorage.services.s3.model.StorageClass;
import com.ibm.cloud.objectstorage.services.s3.transfer.TransferManager;
import com.ibm.cloud.objectstorage.services.s3.transfer.TransferManagerBuilder;
import com.ibm.cloud.objectstorage.services.s3.transfer.Upload;
import com.liferay.document.library.kernel.exception.AccessDeniedException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.store.s3.S3FileCache;
import com.liferay.portal.store.s3.S3KeyTransformer;
import com.liferay.portal.store.s3.configuration.S3StoreConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.store.s3.configuration.S3StoreConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"store.type=com.liferay.portal.store.s3.IBMS3Store"}, service={Store.class})
public class IBMS3Store
implements Store {
    private static final int _DELETE_MAX = 1000;
    private static final String _ERROR_CODE_FILE_NOT_FOUND = "NoSuchKey";
    private static final int _STATUS_CODE_FILE_NOT_FOUND = 404;
    private static final Log _log = LogFactoryUtil.getLog(IBMS3Store.class);
    private static volatile S3StoreConfiguration _s3StoreConfiguration;
    private AmazonS3 _amazonS3;
    private AWSCredentialsProvider _awsCredentialsProvider;
    private String _bucketName;
    @Reference
    private S3FileCache _s3FileCache;
    @Reference
    private S3KeyTransformer _s3KeyTransformer;
    private StorageClass _storageClass;
    private TransferManager _transferManager;

    public void addFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream inputStream) {
        if (this.hasFile(companyId, repositoryId, fileName, versionLabel)) {
            this.deleteFile(companyId, repositoryId, fileName, versionLabel);
        }
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            this.putObject(companyId, repositoryId, fileName, versionLabel, file);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        String key = this._s3KeyTransformer.getDirectoryKey(companyId, repositoryId, dirName);
        this.deleteObjects(key);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        try {
            String key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this._bucketName, key);
            this._amazonS3.deleteObject(deleteObjectRequest);
        }
        catch (AmazonClientException amazonClientException) {
            throw this.transform(amazonClientException);
        }
    }

    public String getBucketName() {
        return this._bucketName;
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this._s3FileCache.cleanUpCacheFiles();
        try {
            S3Object s3Object = this.getS3Object(companyId, repositoryId, fileName, versionLabel);
            ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
            return this._s3FileCache.getCacheFileInputStream((Closeable)s3Object, fileName, () -> ((S3Object)s3Object).getObjectContent(), objectMetadata.getLastModified());
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) {
        String key = null;
        key = Validator.isNull((String)dirName) ? this._s3KeyTransformer.getRepositoryKey(companyId, repositoryId) : this._s3KeyTransformer.getDirectoryKey(companyId, repositoryId, dirName);
        List<S3ObjectSummary> s3ObjectSummaries = this.getS3ObjectSummaries(key);
        Iterator<S3ObjectSummary> iterator = s3ObjectSummaries.iterator();
        String[] fileNames = new String[s3ObjectSummaries.size()];
        for (int i = 0; i < fileNames.length; ++i) {
            S3ObjectSummary s3ObjectSummary = iterator.next();
            fileNames[i] = this._s3KeyTransformer.getFileName(s3ObjectSummary.getKey());
        }
        return fileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        String key;
        GetObjectMetadataRequest getObjectMetadataRequest;
        ObjectMetadata objectMetadata;
        if (Validator.isNull((String)versionLabel)) {
            versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
        }
        if ((objectMetadata = this._amazonS3.getObjectMetadata(getObjectMetadataRequest = new GetObjectMetadataRequest(this._bucketName, key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel)))) == null) {
            throw new NoSuchFileException(companyId, repositoryId, fileName);
        }
        return objectMetadata.getContentLength();
    }

    public String[] getFileVersions(long companyId, long repositoryId, String fileName) {
        String key = this._s3KeyTransformer.getFileKey(companyId, repositoryId, fileName);
        List<S3ObjectSummary> s3ObjectSummaries = this.getS3ObjectSummaries(key);
        if (s3ObjectSummaries.isEmpty()) {
            return StringPool.EMPTY_ARRAY;
        }
        String[] versions = new String[s3ObjectSummaries.size()];
        for (int i = 0; i < s3ObjectSummaries.size(); ++i) {
            S3ObjectSummary s3ObjectSummary = s3ObjectSummaries.get(i);
            String versionKey = s3ObjectSummary.getKey();
            versions[i] = versionKey.substring(versionKey.lastIndexOf(47) + 1);
        }
        Arrays.sort(versions, DLUtil::compareVersions);
        return versions;
    }

    public TransferManager getTransferManager() {
        return this._transferManager;
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) {
        try {
            if (Validator.isNull((String)versionLabel)) {
                versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            }
            String key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
            return this._amazonS3.doesObjectExist(this._bucketName, key);
        }
        catch (AmazonClientException amazonClientException) {
            if (this.isFileNotFound(amazonClientException)) {
                return false;
            }
            throw this.transform(amazonClientException);
        }
        catch (NoSuchFileException noSuchFileException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileException);
            }
            return false;
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        block2: {
            _s3StoreConfiguration = (S3StoreConfiguration)ConfigurableUtil.createConfigurable(S3StoreConfiguration.class, properties);
            this._awsCredentialsProvider = this.getAWSCredentialsProvider();
            this._amazonS3 = this.getAmazonS3(this._awsCredentialsProvider);
            this._bucketName = _s3StoreConfiguration.bucketName();
            this._transferManager = this.getTransferManager(this._amazonS3);
            try {
                this._storageClass = StorageClass.fromValue((String)_s3StoreConfiguration.s3StorageClass());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._storageClass = StorageClass.Standard;
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)(_s3StoreConfiguration.s3StorageClass() + " is not a valid value for the storage class"), (Throwable)illegalArgumentException);
            }
        }
    }

    protected void configureConnectionProtocol(ClientConfiguration clientConfiguration) {
        String connectionProtocol = _s3StoreConfiguration.connectionProtocol();
        if (Validator.isNull((String)connectionProtocol) || connectionProtocol.equals("DEFAULT")) {
            return;
        }
        if (connectionProtocol.equals("HTTP")) {
            clientConfiguration.setProtocol(Protocol.HTTP);
        } else {
            clientConfiguration.setProtocol(Protocol.HTTPS);
        }
    }

    protected void configureProxySettings(ClientConfiguration clientConfiguration) {
        String proxyHost = _s3StoreConfiguration.proxyHost();
        if (Validator.isNull((String)proxyHost)) {
            return;
        }
        clientConfiguration.setProxyHost(proxyHost);
        clientConfiguration.setProxyPort(_s3StoreConfiguration.proxyPort());
        String proxyAuthType = _s3StoreConfiguration.proxyAuthType();
        if (proxyAuthType.equals("ntlm") || proxyAuthType.equals("username-password")) {
            clientConfiguration.setProxyPassword(_s3StoreConfiguration.proxyPassword());
            clientConfiguration.setProxyUsername(_s3StoreConfiguration.proxyUsername());
            if (proxyAuthType.equals("ntlm")) {
                clientConfiguration.setProxyDomain(_s3StoreConfiguration.ntlmProxyDomain());
                clientConfiguration.setProxyWorkstation(_s3StoreConfiguration.ntlmProxyWorkstation());
            }
        }
    }

    protected void configureSignerOverride(ClientConfiguration clientConfiguration) {
        String signerOverride = _s3StoreConfiguration.signerOverride();
        if (Validator.isNull((String)signerOverride)) {
            return;
        }
        clientConfiguration.setSignerOverride(signerOverride);
    }

    @Deactivate
    protected void deactivate() {
        this._amazonS3 = null;
        this._awsCredentialsProvider = null;
        this._bucketName = null;
        _s3StoreConfiguration = null;
    }

    protected void deleteObjects(String prefix) {
        try {
            String[] keys = new String[1000];
            List<S3ObjectSummary> s3ObjectSummaries = this.getS3ObjectSummaries(prefix);
            Iterator<S3ObjectSummary> iterator = s3ObjectSummaries.iterator();
            while (iterator.hasNext()) {
                DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this._bucketName);
                for (int i = 0; i < keys.length; ++i) {
                    if (!iterator.hasNext()) {
                        keys = Arrays.copyOfRange(keys, 0, i);
                        break;
                    }
                    S3ObjectSummary s3ObjectSummary = iterator.next();
                    keys[i] = s3ObjectSummary.getKey();
                }
                deleteObjectsRequest.withKeys(keys);
                this._amazonS3.deleteObjects(deleteObjectsRequest);
            }
        }
        catch (AmazonClientException amazonClientException) {
            throw this.transform(amazonClientException);
        }
    }

    protected AmazonS3 getAmazonS3(AWSCredentialsProvider awsCredentialsProvider) {
        if (Validator.isNotNull((String)_s3StoreConfiguration.s3Endpoint()) && Validator.isNotNull((String)_s3StoreConfiguration.s3Region())) {
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(this.getClientConfiguration())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(_s3StoreConfiguration.s3Endpoint(), _s3StoreConfiguration.s3Region()))).withPathStyleAccessEnabled(Boolean.valueOf(_s3StoreConfiguration.s3PathStyle()))).build();
        }
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(this.getClientConfiguration())).withPathStyleAccessEnabled(Boolean.valueOf(_s3StoreConfiguration.s3PathStyle()));
        if (Validator.isNotNull((String)_s3StoreConfiguration.s3Region())) {
            amazonS3ClientBuilder.setRegion(_s3StoreConfiguration.s3Region());
        }
        return (AmazonS3)amazonS3ClientBuilder.build();
    }

    protected AWSCredentialsProvider getAWSCredentialsProvider() {
        if (Validator.isNotNull((String)_s3StoreConfiguration.accessKey()) && Validator.isNotNull((String)_s3StoreConfiguration.secretKey())) {
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(_s3StoreConfiguration.accessKey(), _s3StoreConfiguration.secretKey());
            return new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        }
        return new DefaultAWSCredentialsProviderChain();
    }

    protected ClientConfiguration getClientConfiguration() {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setConnectionTimeout(_s3StoreConfiguration.connectionTimeout());
        clientConfiguration.setMaxErrorRetry(_s3StoreConfiguration.httpClientMaxErrorRetry());
        clientConfiguration.setMaxConnections(_s3StoreConfiguration.httpClientMaxConnections());
        this.configureConnectionProtocol(clientConfiguration);
        this.configureProxySettings(clientConfiguration);
        this.configureSignerOverride(clientConfiguration);
        return clientConfiguration;
    }

    protected String getHeadVersionLabel(long companyId, long repositoryId, String fileName) throws NoSuchFileException {
        String key = this._s3KeyTransformer.getFileKey(companyId, repositoryId, fileName);
        List<S3ObjectSummary> s3ObjectSummaries = this.getS3ObjectSummaries(key);
        Iterator<S3ObjectSummary> iterator = s3ObjectSummaries.iterator();
        Object[] keys = new String[s3ObjectSummaries.size()];
        for (int i = 0; i < keys.length; ++i) {
            S3ObjectSummary s3ObjectSummary = iterator.next();
            keys[i] = s3ObjectSummary.getKey();
        }
        if (keys.length > 0) {
            Arrays.sort(keys);
            Object headVersionKey = keys[keys.length - 1];
            int x = ((String)headVersionKey).lastIndexOf(47);
            return ((String)headVersionKey).substring(x + 1);
        }
        throw new NoSuchFileException(companyId, repositoryId, fileName);
    }

    protected S3Object getS3Object(long companyId, long repositoryId, String fileName, String versionLabel) throws NoSuchFileException {
        try {
            String key;
            GetObjectRequest getObjectRequest;
            S3Object s3Object;
            if (Validator.isNull((String)versionLabel)) {
                versionLabel = this.getHeadVersionLabel(companyId, repositoryId, fileName);
            }
            if ((s3Object = this._amazonS3.getObject(getObjectRequest = new GetObjectRequest(this._bucketName, key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel)))) == null) {
                throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
            }
            return s3Object;
        }
        catch (AmazonClientException amazonClientException) {
            if (this.isFileNotFound(amazonClientException)) {
                throw new NoSuchFileException(companyId, repositoryId, fileName, versionLabel);
            }
            throw this.transform(amazonClientException);
        }
    }

    protected List<S3ObjectSummary> getS3ObjectSummaries(String prefix) {
        try {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
            listObjectsRequest.withBucketName(this._bucketName);
            listObjectsRequest.withPrefix(prefix);
            ObjectListing objectListing = this._amazonS3.listObjects(listObjectsRequest);
            ArrayList<S3ObjectSummary> s3ObjectSummaries = new ArrayList<S3ObjectSummary>(objectListing.getMaxKeys());
            while (true) {
                s3ObjectSummaries.addAll(objectListing.getObjectSummaries());
                if (!objectListing.isTruncated()) break;
                objectListing = this._amazonS3.listNextBatchOfObjects(objectListing);
            }
            return s3ObjectSummaries;
        }
        catch (AmazonClientException amazonClientException) {
            throw this.transform(amazonClientException);
        }
    }

    protected TransferManager getTransferManager(AmazonS3 amazonS3) {
        return TransferManagerBuilder.standard().withS3Client(amazonS3).withExecutorFactory(() -> new ThreadPoolExecutor(_s3StoreConfiguration.corePoolSize(), _s3StoreConfiguration.maxPoolSize())).withMinimumUploadPartSize(Long.valueOf(_s3StoreConfiguration.minimumUploadPartSize())).withMultipartUploadThreshold(Long.valueOf(_s3StoreConfiguration.multipartUploadThreshold())).withShutDownThreadPools(Boolean.valueOf(false)).build();
    }

    protected boolean isFileNotFound(AmazonClientException amazonClientException) {
        AmazonServiceException amazonServiceException;
        String errorCode;
        return amazonClientException instanceof AmazonServiceException && (errorCode = (amazonServiceException = (AmazonServiceException)amazonClientException).getErrorCode()).equals(_ERROR_CODE_FILE_NOT_FOUND) && amazonServiceException.getStatusCode() == 404;
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this.deactivate();
        this.activate(properties);
    }

    protected void putObject(long companyId, long repositoryId, String fileName, String versionLabel, File file) {
        Upload upload = null;
        try {
            String key = this._s3KeyTransformer.getFileVersionKey(companyId, repositoryId, fileName, versionLabel);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this._bucketName, key, file);
            putObjectRequest.withStorageClass(this._storageClass);
            upload = this._transferManager.upload(putObjectRequest);
            upload.waitForCompletion();
        }
        catch (AmazonClientException amazonClientException) {
            throw this.transform(amazonClientException);
        }
        catch (InterruptedException interruptedException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)interruptedException);
            }
            upload.abort();
            Thread thread = Thread.currentThread();
            thread.interrupt();
        }
    }

    protected SystemException transform(AmazonClientException amazonClientException) {
        if (amazonClientException instanceof AmazonServiceException) {
            AmazonServiceException amazonServiceException = (AmazonServiceException)amazonClientException;
            StringBundler sb = new StringBundler(11);
            sb.append("{errorCode=");
            String errorCode = amazonServiceException.getErrorCode();
            sb.append(errorCode);
            sb.append(", errorType=");
            sb.append((Object)amazonServiceException.getErrorType());
            sb.append(", message=");
            sb.append(amazonServiceException.getMessage());
            sb.append(", requestId=");
            sb.append(amazonServiceException.getRequestId());
            sb.append(", statusCode=");
            sb.append(amazonServiceException.getStatusCode());
            sb.append("}");
            if (errorCode.equals("AccessDenied")) {
                return new AccessDeniedException(sb.toString());
            }
            return new SystemException(sb.toString());
        }
        return new SystemException(amazonClientException.getMessage(), (Throwable)amazonClientException);
    }
}

