/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.s3;

import com.liferay.petra.string.StringBundler;

public class S3KeyTransformerUtil {
    public static String getDirectoryKey(long companyId, long repositoryId, String folderName) {
        return S3KeyTransformerUtil.getFileKey(companyId, repositoryId, folderName);
    }

    public static String getFileKey(long companyId, long repositoryId, String fileName) {
        return StringBundler.concat((Object[])new Object[]{companyId, "/", repositoryId, S3KeyTransformerUtil.getNormalizedFileName(fileName)});
    }

    public static String getFileName(String key) {
        int x = key.indexOf(47);
        x = key.indexOf(47, x + 1);
        int y = key.lastIndexOf(47);
        return key.substring(x + 1, y);
    }

    public static String getFileVersionKey(long companyId, long repositoryId, String fileName, String versionLabel) {
        return StringBundler.concat((Object[])new Object[]{companyId, "/", repositoryId, S3KeyTransformerUtil.getNormalizedFileName(fileName), "/", versionLabel});
    }

    public static String getNormalizedFileName(String fileName) {
        String normalizedFileName = fileName;
        if (!fileName.startsWith("/")) {
            normalizedFileName = "/" + normalizedFileName;
        }
        if (fileName.endsWith("/")) {
            normalizedFileName = normalizedFileName.substring(0, normalizedFileName.length() - 1);
        }
        return normalizedFileName;
    }

    public static String getRepositoryKey(long companyId, long repositoryId) {
        return companyId + "/" + repositoryId;
    }

    public static String moveKey(String key, String oldPrefix, String newPrefix) {
        String name = key.substring(oldPrefix.length());
        return newPrefix.concat(name);
    }
}

