/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.s3.scheduler;

import com.amazonaws.services.s3.transfer.TransferManager;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.store.s3.S3Store;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={SchedulerJobConfiguration.class})
public class AbortedMultipartUploadCleanerSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference(target="(store.type=com.liferay.portal.store.s3.S3Store)")
    private Store _store;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            S3Store s3Store = (S3Store)this._store;
            TransferManager transferManager = s3Store.getTransferManager();
            transferManager.abortMultipartUploads(s3Store.getBucketName(), this._computeStartDate());
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)1, (TimeUnit)TimeUnit.DAY);
    }

    private Date _computeStartDate() {
        Date date = new Date();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime previousDayLocalDateTime = localDateTime.minus(1L, ChronoUnit.DAYS);
        ZonedDateTime zonedDateTime = previousDayLocalDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

