/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.store.test.util;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseStoreTestCase {
    private static final int _DATA_SIZE = 66560;
    private static final byte[] _DATA_VERSION_1 = new byte[66560];
    private static final byte[] _DATA_VERSION_2 = new byte[66560];
    private long _companyId;
    private long _repositoryId;
    private Store _store;

    @Before
    public void setUp() {
        this._companyId = RandomTestUtil.nextLong();
        this._repositoryId = RandomTestUtil.nextLong();
        this._store = this.getStore();
    }

    @After
    public void tearDown() {
        this._store.deleteDirectory(this._companyId, this._repositoryId, "/");
    }

    @Test
    public void testAddFile() throws Exception {
        String fileName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        Assert.assertTrue((boolean)this._store.hasFile(this._companyId, this._repositoryId, fileName, "1.0"));
    }

    @Test
    public void testDeleteDirectory() throws Exception {
        String dirName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName1, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        String fileName2 = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName2, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        this._store.deleteDirectory(this._companyId, this._repositoryId, dirName);
        Assert.assertFalse((boolean)this._store.hasFile(this._companyId, this._repositoryId, fileName1, "1.0"));
        Assert.assertFalse((boolean)this._store.hasFile(this._companyId, this._repositoryId, fileName2, "1.0"));
    }

    @Test
    public void testDeleteDirectoryWithTwoLevelDeep() throws Exception {
        String dirName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String subdirName = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName1, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        String fileName2 = subdirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName2, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        this._store.deleteDirectory(this._companyId, this._repositoryId, dirName);
        Assert.assertFalse((boolean)this._store.hasFile(this._companyId, this._repositoryId, fileName1, "1.0"));
        Assert.assertFalse((boolean)this._store.hasFile(this._companyId, this._repositoryId, fileName2, "1.0"));
    }

    @Test
    public void testDeleteFile() throws Exception {
        String fileName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        this.addVersions(fileName, 1);
        this._store.deleteFile(this._companyId, this._repositoryId, fileName, "1.0");
        Assert.assertFalse((boolean)this._store.hasFile(this._companyId, this._repositoryId, fileName, "1.0"));
        Assert.assertTrue((boolean)this._store.hasFile(this._companyId, this._repositoryId, fileName, "1.1"));
    }

    @Test
    public void testGetFileAsStream() throws Exception {
        String fileName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        this.addVersions(fileName, 5);
        try (InputStream inputStream = this._store.getFileAsStream(this._companyId, this._repositoryId, fileName, "1.5");){
            for (int i = 0; i < 66560; ++i) {
                Assert.assertEquals((long)_DATA_VERSION_1[i], (long)((byte)inputStream.read()));
            }
            Assert.assertEquals((long)-1L, (long)inputStream.read());
        }
    }

    @Test
    public void testGetFileNames() throws Exception {
        String fileName1 = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName1, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        String fileName2 = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName2, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        Object[] fileNames = this._store.getFileNames(this._companyId, this._repositoryId, "");
        Assert.assertEquals((String)Arrays.toString(fileNames), (long)2L, (long)fileNames.length);
        Set fileNamesSet = SetUtil.fromArray((Object[])fileNames);
        Assert.assertTrue((String)fileNamesSet.toString(), (boolean)fileNamesSet.contains(fileName1));
        Assert.assertTrue((String)fileNamesSet.toString(), (boolean)fileNamesSet.contains(fileName2));
    }

    @Test
    public void testGetFileNamesWithDirectoryOneLevelDeep() throws Exception {
        String dirName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName1, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        String fileName2 = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName2, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        Object[] fileNames = this._store.getFileNames(this._companyId, this._repositoryId, dirName);
        Assert.assertEquals((String)Arrays.toString(fileNames), (long)2L, (long)fileNames.length);
        Set fileNamesSet = SetUtil.fromArray((Object[])fileNames);
        Assert.assertTrue((String)fileNamesSet.toString(), (boolean)fileNamesSet.contains(fileName1));
        Assert.assertTrue((String)fileNamesSet.toString(), (boolean)fileNamesSet.contains(fileName2));
    }

    @Test
    public void testGetFileNamesWithDirectoryTwoLevelDeep() throws Exception {
        String dirName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String subdirName = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName1, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        String fileName2 = subdirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName2, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        String fileName3 = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]) + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName3, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        Object[] fileNames = this._store.getFileNames(this._companyId, this._repositoryId, dirName);
        Assert.assertEquals((String)Arrays.toString(fileNames), (long)2L, (long)fileNames.length);
        Set fileNamesSet = SetUtil.fromArray((Object[])fileNames);
        Assert.assertTrue((String)fileNamesSet.toString(), (boolean)fileNamesSet.contains(fileName1));
        Assert.assertTrue((String)fileNamesSet.toString(), (boolean)fileNamesSet.contains(fileName2));
        fileNames = this._store.getFileNames(this._companyId, this._repositoryId, subdirName);
        Assert.assertEquals((String)Arrays.toString(fileNames), (long)1L, (long)fileNames.length);
        Assert.assertEquals((Object)fileName2, (Object)fileNames[0]);
    }

    @Test
    public void testGetFileNamesWithInvalidDirectory() {
        String dirName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        Object[] fileNames = this._store.getFileNames(this._companyId, this._repositoryId, dirName);
        Assert.assertEquals((String)Arrays.toString(fileNames), (long)0L, (long)fileNames.length);
    }

    @Test
    public void testGetFileNamesWithInvalidRepository() {
        Object[] fileNames = this._store.getFileNames(this._companyId, this._repositoryId, "");
        Assert.assertEquals((String)Arrays.toString(fileNames), (long)0L, (long)fileNames.length);
    }

    @Test
    public void testGetFileNamesWithTwoLevelsDeep() throws Exception {
        String dirName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String subdirName = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        String fileName1 = dirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName1, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        String fileName2 = subdirName + "/" + RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName2, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        Object[] fileNames = this._store.getFileNames(this._companyId, this._repositoryId, "");
        Assert.assertEquals((String)Arrays.toString(fileNames), (long)2L, (long)fileNames.length);
        Set fileNamesSet = SetUtil.fromArray((Object[])fileNames);
        Assert.assertTrue((String)fileNamesSet.toString(), (boolean)fileNamesSet.contains(fileName1));
        Assert.assertTrue((String)fileNamesSet.toString(), (boolean)fileNamesSet.contains(fileName2));
    }

    @Test
    public void testGetFileSize() throws Exception {
        String fileName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        long size = this._store.getFileSize(this._companyId, this._repositoryId, fileName, "");
        Assert.assertEquals((long)66560L, (long)size);
    }

    @Test(expected=NoSuchFileException.class)
    public void testGetFileSizeNoSuchFileException() throws Exception {
        this._store.getFileSize(this._companyId, this._repositoryId, RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), "");
    }

    @Test
    public void testGetFileVersions() throws Exception {
        String fileName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        this.addVersions(fileName, 5);
        String[] fileVersions = this._store.getFileVersions(this._companyId, this._repositoryId, fileName);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)("1." + i), (Object)fileVersions[i]);
        }
    }

    @Test
    public void testHasFile() throws Exception {
        String fileName = RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]);
        this._store.addFile(this._companyId, this._repositoryId, fileName, "1.0", (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        this.addVersions(fileName, 5);
        String versionLabel = "1.";
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)this._store.hasFile(this._companyId, this._repositoryId, fileName, versionLabel + i));
        }
    }

    protected void addVersions(String fileName, int newVersionCount) throws Exception {
        String versionLabel = "1.";
        for (int i = 1; i <= newVersionCount; ++i) {
            this._store.addFile(this._companyId, this._repositoryId, fileName, versionLabel + i, (InputStream)new UnsyncByteArrayInputStream(_DATA_VERSION_1));
        }
    }

    protected abstract Store getStore();

    static {
        for (int i = 0; i < 66560; ++i) {
            BaseStoreTestCase._DATA_VERSION_1[i] = (byte)i;
            BaseStoreTestCase._DATA_VERSION_2[i] = (byte)(i + 1);
        }
    }
}

