/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.freemarker.internal;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.concurrent.ThreadPoolHandler;
import com.liferay.petra.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.petra.executor.PortalExecutorConfig;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.JSPSupportServlet;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.template.BaseTemplateResourceCache;
import com.liferay.portal.template.BaseTemplateResourceLoader;
import com.liferay.portal.template.engine.BaseTemplateManager;
import com.liferay.portal.template.engine.TemplateContextHelper;
import com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration;
import com.liferay.portal.template.freemarker.internal.FreeMarkerBundleClassloader;
import com.liferay.portal.template.freemarker.internal.FreeMarkerTemplate;
import com.liferay.portal.template.freemarker.internal.LiferayObjectWrapper;
import com.liferay.portal.template.freemarker.internal.LiferayTemplateCache;
import com.liferay.portal.template.freemarker.internal.RestrictedLiferayObjectWrapper;
import com.liferay.portal.template.freemarker.internal.UnsyncStringWriterFactory;
import com.liferay.portal.template.freemarker.internal.helper.FreeMarkerTemplateContextHelper;
import freemarker.cache.TemplateCache;
import freemarker.core.TemplateClassResolver;
import freemarker.debug.impl.DebuggerService;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.jsp.internal.WriterFactoryUtil;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.template.freemarker.configuration.FreeMarkerEngineConfiguration"}, property={"language.type=ftl"}, service={TemplateManager.class})
public class FreeMarkerManager
extends BaseTemplateManager {
    private static final String _LIFERAY_MACRO_LIBRARY = "FTL_liferay.ftl as liferay";
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerManager.class);
    private static final Function<InvocationHandler, ServletContext> _servletContextProxyProviderFunction = ProxyUtil.getProxyProviderFunction((Class[])new Class[]{ServletContext.class});
    private Bundle _bundle;
    private BundleTracker<ClassLoader> _bundleTracker;
    private volatile Configuration _configuration;
    private volatile BeansWrapper _defaultBeansWrapper;
    private volatile FreeMarkerBundleClassloader _freeMarkerBundleClassloader;
    private volatile FreeMarkerEngineConfiguration _freeMarkerEngineConfiguration;
    private FreeMarkerTemplateResourceCache _freeMarkerTemplateResourceCache;
    private volatile FreeMarkerTemplateResourceLoader _freeMarkerTemplateResourceLoader;
    private volatile NoticeableExecutorService _noticeableExecutorService;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    private volatile BeansWrapper _restrictedBeansWrapper;
    private volatile ServiceRegistration<PortalExecutorConfig> _serviceRegistration;
    private final Map<ClassLoader, Map<String, String>> _taglibMappings = new ConcurrentHashMap<ClassLoader, Map<String, String>>();
    @Reference
    private TemplateClassResolver _templateClassResolver;
    @Reference(target="(component.name=com.liferay.portal.template.freemarker.internal.helper.FreeMarkerTemplateContextHelper)")
    private TemplateContextHelper _templateContextHelper;
    private final Map<String, TemplateModel> _templateModels = new ConcurrentHashMap<String, TemplateModel>();
    private ServiceRegistration<TemplateResourceLoader> _templateResourceLoaderServiceRegistration;
    private volatile Map<String, AtomicInteger> _timeoutTemplateCounters;

    public String getName() {
        return "ftl";
    }

    public String[] getRestrictedVariables() {
        return this._freeMarkerEngineConfiguration.restrictedVariables();
    }

    @Activate
    protected void activate(ComponentContext componentContext) throws TemplateException {
        BundleContext bundleContext = componentContext.getBundleContext();
        this._bundle = bundleContext.getBundle();
        this._bundleTracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)new TaglibBundleTrackerCustomizer());
        this._bundleTracker.open();
        this._freeMarkerEngineConfiguration = (FreeMarkerEngineConfiguration)ConfigurableUtil.createConfigurable(FreeMarkerEngineConfiguration.class, (Dictionary)componentContext.getProperties());
        this._freeMarkerTemplateResourceCache = new FreeMarkerTemplateResourceCache();
        this._freeMarkerTemplateResourceLoader = new FreeMarkerTemplateResourceLoader(bundleContext, (TemplateResourceCache)this._freeMarkerTemplateResourceCache);
        this._templateResourceLoaderServiceRegistration = bundleContext.registerService(TemplateResourceLoader.class, (Object)this._freeMarkerTemplateResourceLoader, null);
        WriterFactoryUtil.setWriterFactory(new UnsyncStringWriterFactory());
        this._initAsyncRender(bundleContext);
        this._init();
    }

    protected void addTaglibSupport(Map<String, Object> contextObjects, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ObjectWrapper objectWrapper) {
        ServletContext servletContext = httpServletRequest.getServletContext();
        contextObjects.put("Application", this._getServletContextHashModel(servletContext, objectWrapper));
        contextObjects.put("Request", new HttpRequestHashModel(httpServletRequest, httpServletResponse, objectWrapper));
        FreeMarkerBundleClassloader freeMarkerBundleClassloader = this._freeMarkerBundleClassloader;
        if (freeMarkerBundleClassloader == null) {
            this._freeMarkerBundleClassloader = freeMarkerBundleClassloader = new FreeMarkerBundleClassloader(this._taglibMappings.keySet());
        }
        TaglibFactoryWrapper taglibFactoryWrapper = new TaglibFactoryWrapper(freeMarkerBundleClassloader, objectWrapper, servletContext);
        contextObjects.put("PortalJspTagLibs", taglibFactoryWrapper);
        contextObjects.put("PortletJspTagLibs", taglibFactoryWrapper);
        contextObjects.put("taglibLiferayHash", taglibFactoryWrapper);
        for (Map<String, String> map : this._taglibMappings.values()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                try {
                    contextObjects.put(entry.getKey(), taglibFactoryWrapper.get(entry.getValue()));
                }
                catch (TemplateModelException templateModelException) {
                    _log.error((Object)("Unable to add taglib " + entry.getKey() + " to context"), (Throwable)templateModelException);
                }
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        this._destroy();
        this._bundleTracker.close();
        if (this._freeMarkerEngineConfiguration.asyncRenderTimeout() > 0L) {
            this._noticeableExecutorService.shutdownNow();
            this._timeoutTemplateCounters.clear();
            this._serviceRegistration.unregister();
        }
        this._templateResourceLoaderServiceRegistration.unregister();
        this._freeMarkerTemplateResourceCache.destroy();
        this._freeMarkerTemplateResourceLoader.destroy();
    }

    protected Template doGetTemplate(TemplateResource templateResource, boolean restricted, Map<String, Object> helperUtilities) {
        BeansWrapper beansWrapper = this._defaultBeansWrapper;
        if (restricted) {
            beansWrapper = this._restrictedBeansWrapper;
        }
        return new FreeMarkerTemplate(templateResource, helperUtilities, this._configuration, this._templateContextHelper, (TemplateResourceCache)this._freeMarkerTemplateResourceCache, restricted, beansWrapper, this);
    }

    protected TemplateContextHelper getTemplateContextHelper() {
        return this._templateContextHelper;
    }

    @Modified
    protected void modified(ComponentContext componentContext) throws TemplateException {
        if (this._freeMarkerEngineConfiguration.asyncRenderTimeout() > 0L) {
            this._noticeableExecutorService.shutdownNow();
            this._noticeableExecutorService = null;
            this._serviceRegistration.unregister();
            this._serviceRegistration = null;
            this._timeoutTemplateCounters.clear();
            this._timeoutTemplateCounters = null;
        }
        this._freeMarkerEngineConfiguration = (FreeMarkerEngineConfiguration)ConfigurableUtil.createConfigurable(FreeMarkerEngineConfiguration.class, (Dictionary)componentContext.getProperties());
        this._initAsyncRender(componentContext.getBundleContext());
        this._destroy();
        this._init();
    }

    protected void render(String templateId, Writer writer, boolean restricted, Callable<Void> callable) throws Exception {
        long timeout = this._freeMarkerEngineConfiguration.asyncRenderTimeout();
        if (timeout <= 0L || !restricted) {
            callable.call();
            return;
        }
        AtomicInteger timeoutCounter = this._timeoutTemplateCounters.computeIfAbsent(templateId, key -> new AtomicInteger(0));
        if (timeoutCounter.get() >= this._freeMarkerEngineConfiguration.asyncRenderTimeoutThreshold()) {
            throw new IllegalStateException(StringBundler.concat((Object[])new Object[]{"Skip processing FreeMarker template ", templateId, " since it has timed out ", this._freeMarkerEngineConfiguration.asyncRenderTimeoutThreshold(), " times"}));
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Object threadLocals = ThreadLocalUtil._cloneThreadLocals(currentThread);
        NoticeableFuture noticeableFuture = this._noticeableExecutorService.submit(() -> {
            Thread thread = Thread.currentThread();
            try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)contextClassLoader);){
                ThreadLocalUtil._setThreadLocals(thread, threadLocals);
                callable.call();
            }
            finally {
                ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
                ThreadLocalUtil._setThreadLocals(thread, null);
            }
            return null;
        });
        try {
            noticeableFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
        catch (TimeoutException timeoutException) {
            timeoutCounter.incrementAndGet();
            String errorMessage = StringBundler.concat((String[])new String[]{"FreeMarker template ", templateId, " processing timeout"});
            writer.write(errorMessage);
            _log.error((Object)errorMessage, (Throwable)timeoutException);
            ThreadLocalUtil._clearThreadLocals(threadLocals);
        }
    }

    private void _destroy() {
        if (this._configuration == null) {
            return;
        }
        this._configuration.clearEncodingMap();
        this._configuration.clearSharedVariables();
        this._configuration.clearTemplateCache();
        this._configuration = null;
        this._templateContextHelper.removeAllHelperUtilities();
        this._templateModels.clear();
        if (this._isEnableDebuggerService()) {
            // empty if block
        }
    }

    private String[] _filterRestrictedClasses(String[] restrictedClasses) {
        if (JavaDetector.isJDK21()) {
            return ArrayUtil.remove((String[])restrictedClasses, (String)"java.lang.Compiler");
        }
        return restrictedClasses;
    }

    private String _getMacroLibrary() {
        Set macroLibraries = SetUtil.fromArray((Object[])this._freeMarkerEngineConfiguration.macroLibrary());
        macroLibraries.add(_LIFERAY_MACRO_LIBRARY);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String contextName = ClassLoaderPool.getContextName((ClassLoader)clazz.getClassLoader());
        contextName = contextName.concat("_CLASS_LOADER_CONTEXT_");
        StringBundler sb = new StringBundler(3 * macroLibraries.size());
        for (String library : macroLibraries) {
            if (this._hasLibrary(library)) {
                sb.append(contextName);
                sb.append(library);
                sb.append(",");
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)("Unable to find library: " + library));
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private ServletContextHashModel _getServletContextHashModel(ServletContext servletContext, ObjectWrapper objectWrapper) {
        JSPSupportServlet genericServlet = new JSPSupportServlet(servletContext);
        return new ServletContextHashModel((GenericServlet)genericServlet, objectWrapper);
    }

    private boolean _hasLibrary(String library) {
        int index = library.indexOf(32);
        if (index != -1) {
            library = library.substring(0, index);
        }
        return this._bundle.getResource(library) != null;
    }

    private void _init() throws TemplateException {
        if (this._configuration != null) {
            return;
        }
        this._configuration = new Configuration(Configuration.VERSION_2_3_33);
        this._configuration.setAttemptExceptionReporter((templateException, environment) -> {});
        this._configuration.setDefaultEncoding("UTF-8");
        this._configuration.setLocalizedLookup(this._freeMarkerEngineConfiguration.localizedLookup());
        this._configuration.setNewBuiltinClassResolver(this._templateClassResolver);
        try {
            this._configuration.setLogTemplateExceptions(this._freeMarkerEngineConfiguration.logTemplateExceptions());
            this._configuration.setSetting("auto_import", this._getMacroLibrary());
            this._configuration.setSetting("template_exception_handler", this._freeMarkerEngineConfiguration.templateExceptionHandler());
            Field field = ReflectionUtil.getDeclaredField(Configuration.class, (String)"cache");
            PortalCache portalCache = this._freeMarkerTemplateResourceCache.getSecondLevelPortalCache();
            LiferayTemplateCache templateCache = new LiferayTemplateCache(this._configuration, (TemplateResourceLoader)this._freeMarkerTemplateResourceLoader, (PortalCache<TemplateResource, TemplateCache.MaybeMissingTemplate>)portalCache);
            field.set(this._configuration, templateCache);
            this._configuration.setSharedVariable("loop-count-threshold", new SimpleNumber(this._freeMarkerEngineConfiguration.loopCountThreshold()));
        }
        catch (Exception exception) {
            throw new TemplateException("Unable to init FreeMarker manager", (Throwable)exception);
        }
        this._defaultBeansWrapper = new LiferayObjectWrapper();
        this._restrictedBeansWrapper = new RestrictedLiferayObjectWrapper(this._freeMarkerEngineConfiguration.allowedClasses(), this._filterRestrictedClasses(this._freeMarkerEngineConfiguration.restrictedClasses()), this._freeMarkerEngineConfiguration.restrictedMethods());
        if (this._isEnableDebuggerService()) {
            DebuggerService.getBreakpoints("*");
        }
        FreeMarkerTemplateContextHelper freeMarkerTemplateContextHelper = (FreeMarkerTemplateContextHelper)this._templateContextHelper;
        freeMarkerTemplateContextHelper.setDefaultBeansWrapper(this._defaultBeansWrapper);
        freeMarkerTemplateContextHelper.setRestrictedBeansWrapper(this._restrictedBeansWrapper);
    }

    private void _initAsyncRender(BundleContext bundleContext) {
        if (this._freeMarkerEngineConfiguration.asyncRenderTimeout() <= 0L) {
            return;
        }
        this._noticeableExecutorService = this._portalExecutorManager.getPortalExecutor(FreeMarkerManager.class.getName());
        this._serviceRegistration = bundleContext.registerService(PortalExecutorConfig.class, (Object)new PortalExecutorConfig(FreeMarkerManager.class.getName(), 1, this._freeMarkerEngineConfiguration.asyncRenderThreadPoolMaxSize(), 60L, TimeUnit.SECONDS, this._freeMarkerEngineConfiguration.asyncRenderThreadPoolMaxQueueSize(), (ThreadFactory)new NamedThreadFactory(FreeMarkerManager.class.getName(), 5, null), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy(), (ThreadPoolHandler)new ThreadPoolHandlerAdapter()), null);
        this._timeoutTemplateCounters = new ConcurrentHashMap<String, AtomicInteger>();
    }

    private boolean _isEnableDebuggerService() {
        return System.getProperty("freemarker.debug.password") != null && System.getProperty("freemarker.debug.port") != null;
    }

    private class TaglibBundleTrackerCustomizer
    implements BundleTrackerCustomizer<ClassLoader> {
        private TaglibBundleTrackerCustomizer() {
        }

        public ClassLoader addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            URL url = bundle.getEntry("/META-INF/taglib-mappings.properties");
            if (url == null) {
                return null;
            }
            try {
                Properties properties = PropertiesUtil.load((URL)url);
                Map map = PropertiesUtil.toMap((Properties)properties);
                if (map.isEmpty()) {
                    return null;
                }
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                FreeMarkerManager.this._taglibMappings.put(bundleWiring.getClassLoader(), map);
                FreeMarkerManager.this._freeMarkerBundleClassloader = null;
                return bundleWiring.getClassLoader();
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                return null;
            }
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, ClassLoader classLoader) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, ClassLoader classLoader) {
            FreeMarkerManager.this._taglibMappings.remove(classLoader);
            FreeMarkerManager.this._templateModels.clear();
            FreeMarkerManager.this._freeMarkerBundleClassloader = null;
        }
    }

    public class FreeMarkerTemplateResourceCache
    extends BaseTemplateResourceCache {
        private final String _portalCacheName = FreeMarkerTemplateResourceCache.class.getName();

        public FreeMarkerTemplateResourceCache() {
            this.init(Long.MIN_VALUE, this._portalCacheName, StringBundler.concat((String[])new String[]{TemplateResource.class.getName(), "#", "ftl"}));
        }

        public void destroy() {
            super.destroy();
        }
    }

    public class FreeMarkerTemplateResourceLoader
    extends BaseTemplateResourceLoader {
        public FreeMarkerTemplateResourceLoader(BundleContext bundleContext, TemplateResourceCache templateResourceCache) {
            this.init(bundleContext, "ftl", templateResourceCache);
        }

        public void destroy() {
            super.destroy();
        }
    }

    private class TaglibFactoryWrapper
    implements TemplateHashModel {
        private final FreeMarkerBundleClassloader _freeMarkerBundleClassloader;
        private final TaglibFactory _taglibFactory;

        public TaglibFactoryWrapper(FreeMarkerBundleClassloader freeMarkerBundleClassloader, ObjectWrapper objectWrapper, ServletContext servletContext) {
            this._freeMarkerBundleClassloader = freeMarkerBundleClassloader;
            this._taglibFactory = new TaglibFactory(_servletContextProxyProviderFunction.apply(new ServletContextInvocationHandler(this._freeMarkerBundleClassloader, servletContext)));
            this._taglibFactory.setObjectWrapper(objectWrapper);
        }

        @Override
        public TemplateModel get(String uri) throws TemplateModelException {
            TemplateModel templateModel = FreeMarkerManager.this._templateModels.get(uri);
            if (templateModel == null) {
                try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)this._freeMarkerBundleClassloader);){
                    templateModel = this._taglibFactory.get(uri);
                }
                FreeMarkerManager.this._templateModels.put(uri, templateModel);
            }
            return templateModel;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static class ThreadLocalUtil {
        private static final Class<?> _ENTRY_CLASS;
        private static final Method _createInheritedMapMethod;
        private static final Field _sizeField;
        private static final Field _tableField;
        private static final Field _threadLocalsField;
        private static final Field _thresholdField;

        private ThreadLocalUtil() {
        }

        private static void _clearThreadLocals(Object threadLocals) throws Exception {
            _sizeField.set(threadLocals, 0);
            _tableField.set(threadLocals, Array.newInstance(_ENTRY_CLASS, 0));
            _thresholdField.set(threadLocals, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object _cloneThreadLocals(Thread thread) throws Exception {
            Object threadLocals = _threadLocalsField.get(thread);
            Object table = _tableField.get(threadLocals);
            int length = Array.getLength(table);
            try {
                _tableField.set(threadLocals, Array.newInstance(_ENTRY_CLASS, length));
                Object clonedThreadLocals = _createInheritedMapMethod.invoke(null, threadLocals);
                System.arraycopy(table, 0, _tableField.get(clonedThreadLocals), 0, length);
                _sizeField.set(clonedThreadLocals, _sizeField.get(threadLocals));
                Object object = clonedThreadLocals;
                return object;
            }
            finally {
                _tableField.set(threadLocals, table);
            }
        }

        private static void _setThreadLocals(Thread thread, Object threadLocals) throws Exception {
            _threadLocalsField.set(thread, threadLocals);
        }

        static {
            try {
                _threadLocalsField = ReflectionUtil.getDeclaredField(Thread.class, (String)"threadLocals");
                Class<?> threadLocalMapClass = _threadLocalsField.getType();
                _createInheritedMapMethod = ReflectionUtil.getDeclaredMethod(ThreadLocal.class, (String)"createInheritedMap", (Class[])new Class[]{threadLocalMapClass});
                _sizeField = ReflectionUtil.getDeclaredField(threadLocalMapClass, (String)"size");
                _tableField = ReflectionUtil.getDeclaredField(threadLocalMapClass, (String)"table");
                _thresholdField = ReflectionUtil.getDeclaredField(threadLocalMapClass, (String)"threshold");
                Class<?> tableFieldType = _tableField.getType();
                _ENTRY_CLASS = tableFieldType.getComponentType();
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }

    private class ServletContextInvocationHandler
    implements InvocationHandler {
        private final FreeMarkerBundleClassloader _freeMarkerBundleClassloader;
        private final ServletContext _servletContext;

        public ServletContextInvocationHandler(FreeMarkerBundleClassloader freeMarkerBundleClassloader, ServletContext servletContext) {
            this._freeMarkerBundleClassloader = freeMarkerBundleClassloader;
            this._servletContext = servletContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getClassLoader")) {
                return this._freeMarkerBundleClassloader;
            }
            if (methodName.equals("getResource")) {
                return this._getResource((String)args[0]);
            }
            if (methodName.equals("getResourceAsStream")) {
                return this._getResourceAsInputStream((String)args[0]);
            }
            if (methodName.equals("getResourcePaths")) {
                return this._getResourcePaths((String)args[0]);
            }
            return method.invoke((Object)this._servletContext, args);
        }

        private URL _getExtension(String path) {
            Enumeration enumeration = FreeMarkerManager.this._bundle.findEntries("META-INF/resources", path.substring(1), false);
            if (enumeration == null) {
                return null;
            }
            ArrayList urls = Collections.list(enumeration);
            return (URL)urls.get(urls.size() - 1);
        }

        private URL _getResource(String path) {
            String adaptedPath;
            URL url;
            if (((String)path).charAt(0) != '/') {
                path = "/" + (String)path;
            }
            if ((url = this._getExtension((String)path)) != null) {
                return url;
            }
            url = this._freeMarkerBundleClassloader.getResource((String)path);
            if (url != null) {
                return url;
            }
            if (((String)path).startsWith("/WEB-INF/tld/") && (url = this._getExtension(adaptedPath = "/META-INF/" + ((String)path).substring("/WEB-INF/tld/".length()))) == null) {
                url = FreeMarkerManager.this._bundle.getResource(adaptedPath);
            }
            if (url != null) {
                return url;
            }
            if (!((String)path).startsWith("/META-INF/") && !((String)path).startsWith("/WEB-INF/")) {
                url = FreeMarkerManager.this._bundle.getResource("/META-INF/resources" + (String)path);
            }
            return url;
        }

        private InputStream _getResourceAsInputStream(String path) {
            URL url = this._getResource(path);
            if (url == null) {
                return null;
            }
            try {
                return url.openStream();
            }
            catch (IOException ioException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)ioException);
                }
                return null;
            }
        }

        private Set<String> _getResourcePaths(String path) {
            Enumeration enumeration = FreeMarkerManager.this._bundle.findEntries(path, null, true);
            if (enumeration == null) {
                return null;
            }
            HashSet<String> resourcePaths = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                resourcePaths.add(url.getPath());
            }
            return resourcePaths;
        }
    }
}

