Liferay.Loader.define('portal-template-react-renderer-impl$lodash-es@4.17.15/_baseIteratee', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import baseMatches from './_baseMatches.js';
    import baseMatchesProperty from './_baseMatchesProperty.js';
    import identity from './identity.js';
    import isArray from './isArray.js';
    import property from './property.js';

    /**
     * The base implementation of `_.iteratee`.
     *
     * @private
     * @param {*} [value=_.identity] The value to convert to an iteratee.
     * @returns {Function} Returns the iteratee.
     */
    function baseIteratee(value) {
      // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
      // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
      if (typeof value == 'function') {
        return value;
      }
      if (value == null) {
        return identity;
      }
      if (typeof value == 'object') {
        return isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
      }
      return property(value);
    }

    export default baseIteratee;
  }
});
//# sourceMappingURL=_baseIteratee.js.map