/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.react.renderer.internal;

import com.liferay.frontend.js.loader.modules.extender.esm.ESImportUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolvedPackageNameUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.template.react.renderer.ComponentDescriptor;
import com.liferay.portal.template.react.renderer.ReactRenderer;
import com.liferay.portal.template.react.renderer.internal.ReactRendererUtil;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilderFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ReactRenderer.class})
public class ReactRendererImpl
implements ReactRenderer {
    @Reference
    private AbsolutePortalURLBuilderFactory _absolutePortalURLBuilderFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.web.symbolicname=com.liferay.portal.template.react.renderer.impl)", unbind="-")
    private ServletContext _servletContext;

    public void renderReact(ComponentDescriptor componentDescriptor, Map<String, Object> data, HttpServletRequest httpServletRequest, Writer writer) throws IOException {
        String placeholderId = StringUtil.randomId();
        this._renderPlaceholder(writer, placeholderId);
        if (ESImportUtil.isESImport((String)componentDescriptor.getModule())) {
            ReactRendererUtil.renderEcmaScript(this._absolutePortalURLBuilderFactory.getAbsolutePortalURLBuilder(httpServletRequest), componentDescriptor, httpServletRequest, this._jsonFactory, placeholderId, this._portal, this._prepareProps(componentDescriptor, data, httpServletRequest), writer);
        } else {
            ReactRendererUtil.renderJavaScript(componentDescriptor, this._prepareProps(componentDescriptor, data, httpServletRequest), httpServletRequest, this._jsonFactory, NPMResolvedPackageNameUtil.get((ServletContext)this._servletContext), placeholderId, this._portal, writer);
        }
    }

    private Map<String, Object> _prepareProps(ComponentDescriptor componentDescriptor, Map<String, Object> props, HttpServletRequest httpServletRequest) {
        String portletId;
        HashMap<String, Object> modifiedProps = null;
        if (!props.containsKey("componentId")) {
            if (modifiedProps == null) {
                modifiedProps = new HashMap<String, Object>(props);
            }
            modifiedProps.put("componentId", componentDescriptor.getComponentId());
        }
        if (!props.containsKey("locale")) {
            if (modifiedProps == null) {
                modifiedProps = new HashMap<String, Object>(props);
            }
            modifiedProps.put("locale", LocaleUtil.toMap((Locale)LocaleUtil.getMostRelevantLocale()));
        }
        if ((portletId = (String)props.get("portletId")) == null) {
            if (modifiedProps == null) {
                modifiedProps = new HashMap<String, Object>(props);
            }
            portletId = this._portal.getPortletId(httpServletRequest);
            modifiedProps.put("portletId", portletId);
        }
        if (portletId != null && !props.containsKey("portletNamespace")) {
            if (modifiedProps == null) {
                modifiedProps = new HashMap<String, Object>(props);
            }
            modifiedProps.put("portletNamespace", this._portal.getPortletNamespace(portletId));
        }
        if (modifiedProps == null) {
            return props;
        }
        return modifiedProps;
    }

    private void _renderPlaceholder(Writer writer, String placeholderId) throws IOException {
        writer.append("<div id=\"");
        writer.append(placeholderId);
        writer.append("\"></div>");
    }
}

