/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.template.TemplateResourceThreadLocal;
import com.liferay.portal.template.engine.BaseTemplate;
import com.liferay.portal.template.engine.TemplateContextHelper;
import com.liferay.portal.template.velocity.internal.RestrictedTemplateThreadLocal;
import com.liferay.taglib.util.VelocityTaglibImpl;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;

public class VelocityTemplate
extends BaseTemplate {
    private final boolean _restricted;
    private final TemplateResourceCache _templateResourceCache;
    private final VelocityContext _velocityContext;
    private final VelocityEngine _velocityEngine;

    public VelocityTemplate(TemplateResource templateResource, Map<String, Object> context, VelocityEngine velocityEngine, TemplateContextHelper templateContextHelper, TemplateResourceCache templateResourceCache, boolean restricted) {
        super(templateResource, context, templateContextHelper, restricted);
        this._velocityEngine = velocityEngine;
        this._templateResourceCache = templateResourceCache;
        this._restricted = restricted;
        this._velocityContext = new VelocityContext(this.context);
        if (templateResourceCache.isEnabled()) {
            this.cacheTemplateResource(templateResourceCache, templateResource);
        }
    }

    public void prepareTaglib(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        VelocityTaglibImpl velocityTaglib = new VelocityTaglibImpl(httpServletRequest.getServletContext(), httpServletRequest, httpServletResponse, this.context);
        this.context.put("taglibLiferay", velocityTaglib);
        this.context.put("theme", velocityTaglib);
    }

    protected void handleException(TemplateResource templateResource, TemplateResource errorTemplateResource, Exception exception1, Writer writer) throws TemplateException {
        if (this._templateResourceCache.isEnabled()) {
            this.cacheTemplateResource(this._templateResourceCache, errorTemplateResource);
        }
        this.put("exception", exception1.getMessage());
        if (templateResource instanceof StringTemplateResource) {
            StringTemplateResource stringTemplateResource = (StringTemplateResource)templateResource;
            this.put("script", stringTemplateResource.getContent());
        }
        if (exception1 instanceof ParseErrorException) {
            ParseErrorException parseErrorException = (ParseErrorException)exception1;
            this.put("column", parseErrorException.getColumnNumber());
            this.put("line", parseErrorException.getLineNumber());
        }
        try {
            this.processTemplate(errorTemplateResource, writer);
        }
        catch (Exception exception2) {
            throw new TemplateException("Unable to process Velocity template " + errorTemplateResource.getTemplateId(), (Throwable)exception2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplate(TemplateResource templateResource, Writer writer) throws Exception {
        TemplateResourceThreadLocal.setTemplateResource((String)"vm", (TemplateResource)templateResource);
        if (this._restricted) {
            RestrictedTemplateThreadLocal.setRestricted(true);
        }
        try {
            Template template = this._velocityEngine.getTemplate(this.getTemplateResourceUUID(templateResource), "UTF-8");
            template.merge((Context)this._velocityContext, writer);
        }
        finally {
            TemplateResourceThreadLocal.setTemplateResource((String)"vm", null);
            if (this._restricted) {
                RestrictedTemplateThreadLocal.setRestricted(false);
            }
        }
    }
}

