/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import com.liferay.portal.kernel.io.ReaderInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.template.velocity.internal.VelocityManager;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class LiferayResourceLoader
extends ResourceLoader {
    private static final Log _log = LogFactoryUtil.getLog(LiferayResourceLoader.class);
    private TemplateResourceLoader _templateResourceLoader;

    public long getLastModified(Resource resource) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get last modified for " + resource.getName()));
        }
        return 0L;
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        InputStream inputStream = this._getResourceInputStream(source);
        if (inputStream == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find " + source));
            }
            throw new ResourceNotFoundException(source);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Successfully found " + source));
        }
        return inputStream;
    }

    public void init(ExtendedProperties extendedProperties) {
        this._templateResourceLoader = (TemplateResourceLoader)extendedProperties.get((Object)VelocityManager.VelocityTemplateResourceLoader.class.getName());
    }

    public boolean isSourceModified(Resource resource) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Check modified status for " + resource.getName()));
        }
        return false;
    }

    public boolean resourceExists(String resourceName) {
        InputStream inputStream;
        block5: {
            inputStream = null;
            try {
                inputStream = this._getResourceInputStream(resourceName);
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)ioException);
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)resourceNotFoundException);
            }
        }
        return inputStream != null;
    }

    private InputStream _getResourceInputStream(String source) throws ResourceNotFoundException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get resource for " + source));
        }
        try {
            TemplateResource templateResource = this._templateResourceLoader.getTemplateResource(source);
            return new ReaderInputStream(templateResource.getReader());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }
}

