/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.velocity.runtime.ParserPool;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.Parser;

public class VelocityParserPool
implements ParserPool {
    private final AtomicInteger _counter = new AtomicInteger();
    private int _maxSize;
    private final Queue<Parser> _parsers = new ConcurrentLinkedQueue<Parser>();
    private RuntimeServices _runtimeServices;

    public Parser get() {
        Parser parser = this._parsers.poll();
        if (parser == null) {
            parser = this._runtimeServices.createNewParser();
        } else {
            this._counter.getAndDecrement();
        }
        return parser;
    }

    public void initialize(RuntimeServices runtimeServices) {
        this._maxSize = runtimeServices.getInt("parser.pool.size", 20);
        this._runtimeServices = runtimeServices;
    }

    public void put(Parser parser) {
        if (this._counter.get() < this._maxSize) {
            this._counter.getAndIncrement();
            this._parsers.offer(parser);
        }
    }
}

