/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template.velocity.internal.helper;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil_IW;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.TemplatePortletPreferences;
import com.liferay.portal.template.engine.TemplateContextHelper;
import com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.IteratorTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.template.velocity.configuration.VelocityEngineConfiguration"}, service={TemplateContextHelper.class})
public class VelocityTemplateContextHelper
extends TemplateContextHelper {
    private static final Log _log = LogFactoryUtil.getLog(VelocityTemplateContextHelper.class);
    private static volatile VelocityEngineConfiguration _velocityEngineConfiguration;

    public Set<String> getRestrictedVariables() {
        return SetUtil.fromArray((Object[])_velocityEngineConfiguration.restrictedVariables());
    }

    public void prepare(Map<String, Object> contextObjects, HttpServletRequest httpServletRequest) {
        super.prepare(contextObjects, httpServletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            Theme theme = themeDisplay.getTheme();
            String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
            contextObjects.put("fullCssPath", servletContextName + theme.getVelocityResourceListener() + theme.getCssPath());
            String fullTemplatesPath = servletContextName + theme.getVelocityResourceListener() + theme.getTemplatesPath();
            contextObjects.put("fullTemplatesPath", fullTemplatesPath);
            contextObjects.put("init", fullTemplatesPath + "/init.vm");
            if (_velocityEngineConfiguration.includeNavItemsInTheContext() && themeDisplay.getLayout() != null) {
                try {
                    contextObjects.put("navItems", themeDisplay.getNavItems());
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
        }
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        Map vmVariables = (Map)httpServletRequest.getAttribute("VM_VARIABLES" + portletDisplay.getId());
        if (vmVariables != null) {
            for (Map.Entry entry : vmVariables.entrySet()) {
                String key = (String)entry.getKey();
                if (!Validator.isNotNull((String)key)) continue;
                contextObjects.put(key, entry.getValue());
            }
        }
        for (TemplateContextContributor templateContextContributor : this.getTemplateContextContributors()) {
            templateContextContributor.prepare(contextObjects, httpServletRequest);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties, BundleContext bundleContext) {
        this.init(bundleContext);
        _velocityEngineConfiguration = (VelocityEngineConfiguration)ConfigurableUtil.createConfigurable(VelocityEngineConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() {
        this.destory();
    }

    protected void populateExtraHelperUtilities(Map<String, Object> velocityContext, boolean restrict) {
        velocityContext.put("dateTool", new DateTool());
        velocityContext.put("escapeTool", new EscapeTool());
        velocityContext.put("iteratorTool", new IteratorTool());
        velocityContext.put("listTool", new ListTool());
        velocityContext.put("mathTool", new MathTool());
        velocityContext.put("numberTool", new NumberTool());
        velocityContext.put("velocityPortletPreferences", new TemplatePortletPreferences());
        velocityContext.put("sortTool", new SortTool());
        try {
            velocityContext.put("rolePermission", RolePermissionUtil_IW.getInstance());
        }
        catch (SecurityException securityException) {
            _log.error((Throwable)securityException);
        }
    }
}

