/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tika.internal.configuration.helper;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.tika.internal.configuration.TikaConfiguration;
import java.io.InputStream;
import java.util.Map;
import org.apache.tika.config.TikaConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.tika.internal.configuration.TikaConfiguration"}, service={TikaConfigurationHelper.class})
public class TikaConfigurationHelper {
    private static final Log _log = LogFactoryUtil.getLog(TikaConfigurationHelper.class);
    private volatile TikaConfig _tikaConfig;
    private volatile TikaConfiguration _tikaConfiguration;

    public TikaConfig getTikaConfig() {
        return this._tikaConfig;
    }

    public boolean useForkProcess(String mimeType) {
        if (this._tikaConfiguration.textExtractionForkProcessEnabled() && ArrayUtil.contains((Object[])this._tikaConfiguration.textExtractionForkProcessMimeTypes(), (Object)mimeType)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Fork process is enabled for " + mimeType));
            }
            return true;
        }
        return false;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        ClassLoader classLoader;
        Class<TikaConfigurationHelper> clazz = TikaConfigurationHelper.class;
        TikaConfiguration tikaConfiguration = (TikaConfiguration)ConfigurableUtil.createConfigurable(TikaConfiguration.class, properties);
        String tikaConfigXml = tikaConfiguration.tikaConfigXml();
        InputStream inputStream = clazz.getResourceAsStream(tikaConfigXml);
        if (inputStream == null && (inputStream = (classLoader = clazz.getClassLoader()).getResourceAsStream(tikaConfigXml)) == null && (inputStream = (classLoader = PortalClassLoaderUtil.getClassLoader()).getResourceAsStream(tikaConfigXml)) == null) {
            throw new IllegalArgumentException("Unable to read tika configuration " + tikaConfigXml);
        }
        try {
            this._tikaConfig = new TikaConfig(inputStream);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to create tika configuration", exception);
        }
        this._tikaConfiguration = tikaConfiguration;
    }
}

