/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tika.internal.metadata;

import com.drew.imaging.png.PngMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.png.PngDirectory;
import com.liferay.dynamic.data.mapping.kernel.DDMForm;
import com.liferay.dynamic.data.mapping.kernel.DDMFormField;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.metadata.RawMetadataProcessor;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tika.internal.configuration.helper.TikaConfigurationHelper;
import com.liferay.portal.tika.internal.util.ProcessConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.ClimateForcast;
import org.apache.tika.metadata.CreativeCommons;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Geographic;
import org.apache.tika.metadata.HttpHeaders;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaMetadataKeys;
import org.apache.tika.metadata.TikaMimeKeys;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component(service={RawMetadataProcessor.class})
public class TikaRawMetadataProcessor
implements RawMetadataProcessor {
    private static final Log _log = LogFactoryUtil.getLog(TikaRawMetadataProcessor.class);
    private static final Map<String, String> _fields;
    @Reference
    private ProcessExecutor _processExecutor;
    @Reference
    private TikaConfigurationHelper _tikaConfigurationHelper;

    public Set<String> getFieldNames() {
        return _fields.keySet();
    }

    public Map<String, DDMFormValues> getRawMetadataMap(String mimeType, InputStream inputStream) throws PortalException {
        org.apache.tika.metadata.Metadata metadata = this._extractMetadata(mimeType, inputStream);
        return this._createDDMFormValuesMap(metadata);
    }

    private static void _addFields(Class<?> clazz, Map<String, String> fields) throws IllegalAccessException {
        for (Field field : clazz.getFields()) {
            Object value = field.get(null);
            if (value instanceof Property) {
                Property property = (Property)value;
                value = property.getName();
            }
            fields.put(StringBundler.concat((String[])new String[]{clazz.getSimpleName(), "_", field.getName()}), (String)value);
        }
    }

    private DDMForm _createDDMForm(Locale defaultLocale) {
        DDMForm ddmForm = new DDMForm();
        ddmForm.addAvailableLocale(defaultLocale);
        ddmForm.setDefaultLocale(defaultLocale);
        return ddmForm;
    }

    private DDMFormValues _createDDMFormValues(org.apache.tika.metadata.Metadata metadata) {
        Locale defaultLocale = LocaleUtil.getDefault();
        DDMForm ddmForm = this._createDDMForm(defaultLocale);
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.addAvailableLocale(defaultLocale);
        ddmFormValues.setDefaultLocale(defaultLocale);
        for (Map.Entry<String, String> entry : _fields.entrySet()) {
            String value = metadata.get(entry.getValue());
            if (value == null) continue;
            String name = entry.getKey();
            DDMFormField ddmFormField = this._createTextDDMFormField(name);
            ddmForm.addDDMFormField(ddmFormField);
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(name);
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    private Map<String, DDMFormValues> _createDDMFormValuesMap(org.apache.tika.metadata.Metadata metadata) {
        HashMap<String, DDMFormValues> ddmFormValuesMap = new HashMap<String, DDMFormValues>();
        if (metadata == null) {
            return ddmFormValuesMap;
        }
        DDMFormValues ddmFormValues = this._createDDMFormValues(metadata);
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        Set names = ddmFormFieldValuesMap.keySet();
        if (!names.isEmpty()) {
            ddmFormValuesMap.put("TIKARAWMETADATA", ddmFormValues);
        }
        return ddmFormValuesMap;
    }

    private DDMFormField _createTextDDMFormField(String name) {
        DDMFormField ddmFormField = new DDMFormField(name, "text");
        ddmFormField.setDataType("string");
        return ddmFormField;
    }

    private org.apache.tika.metadata.Metadata _extractMetadata(String mimeType, InputStream inputStream) {
        if (Objects.equals(mimeType, "image/png")) {
            return this._getPNGMetadata(inputStream);
        }
        return this._getMetadata(mimeType, inputStream);
    }

    private org.apache.tika.metadata.Metadata _getMetadata(String mimeType, InputStream inputStream) {
        AutoDetectParser parser = new AutoDetectParser(this._tikaConfigurationHelper.getTikaConfig());
        if (this._tikaConfigurationHelper.useForkProcess(mimeType)) {
            File file = FileUtil.createTempFile();
            try {
                FileUtil.write((File)file, (InputStream)inputStream);
                if (file.length() == 0L) {
                    org.apache.tika.metadata.Metadata metadata = null;
                    return metadata;
                }
                ExtractMetadataProcessCallable extractMetadataProcessCallable = new ExtractMetadataProcessCallable(file, (Parser)parser);
                ProcessChannel processChannel = this._processExecutor.execute(ProcessConfigUtil.getProcessConfig(), (ProcessCallable)extractMetadataProcessCallable);
                NoticeableFuture future = processChannel.getProcessNoticeableFuture();
                org.apache.tika.metadata.Metadata metadata = this._postProcessMetadata(mimeType, (org.apache.tika.metadata.Metadata)future.get());
                return metadata;
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            finally {
                file.delete();
            }
        }
        try {
            return this._postProcessMetadata(mimeType, ExtractMetadataProcessCallable._extractMetadata(inputStream, (Parser)parser));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    private org.apache.tika.metadata.Metadata _getPNGMetadata(InputStream inputStream) {
        org.apache.tika.metadata.Metadata metadata;
        block4: {
            metadata = new org.apache.tika.metadata.Metadata();
            try {
                Metadata inputStreamMetadata = PngMetadataReader.readMetadata((InputStream)inputStream);
                PngDirectory pngDirectory = (PngDirectory)inputStreamMetadata.getFirstDirectoryOfType(PngDirectory.class);
                if (pngDirectory == null) {
                    return metadata;
                }
                if (pngDirectory.containsTag(2) && pngDirectory.containsTag(1)) {
                    metadata.set(TIFF.IMAGE_LENGTH, pngDirectory.getInt(2));
                    metadata.set(TIFF.IMAGE_WIDTH, pngDirectory.getInt(1));
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
        return metadata;
    }

    private org.apache.tika.metadata.Metadata _postProcessMetadata(String mimeType, org.apache.tika.metadata.Metadata metadata) {
        String contentType;
        if (mimeType.equals("image/svg+xml") && metadata != null && (contentType = metadata.get("Content-Type")).startsWith("text/plain")) {
            metadata.set("Content-Type", StringUtil.replace((String)contentType, (String)"text/plain", (String)"image/svg+xml"));
        }
        if (mimeType.endsWith("application/javascript") && (contentType = metadata.get("Content-Type")).startsWith("text/x-matlab")) {
            metadata.set("Content-Type", StringUtil.replace((String)contentType, (String)"text/x-matlab", (String)"application/javascript"));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Extracted metadata: " + metadata));
        }
        return metadata;
    }

    static {
        HashMap<String, String> fields = new HashMap<String, String>();
        try {
            TikaRawMetadataProcessor._addFields(ClimateForcast.class, fields);
            TikaRawMetadataProcessor._addFields(CreativeCommons.class, fields);
            TikaRawMetadataProcessor._addFields(DublinCore.class, fields);
            TikaRawMetadataProcessor._addFields(Geographic.class, fields);
            TikaRawMetadataProcessor._addFields(HttpHeaders.class, fields);
            TikaRawMetadataProcessor._addFields(Message.class, fields);
            TikaRawMetadataProcessor._addFields(Office.class, fields);
            TikaRawMetadataProcessor._addFields(OfficeOpenXMLCore.class, fields);
            TikaRawMetadataProcessor._addFields(TIFF.class, fields);
            TikaRawMetadataProcessor._addFields(TikaMetadataKeys.class, fields);
            TikaRawMetadataProcessor._addFields(TikaMimeKeys.class, fields);
            TikaRawMetadataProcessor._addFields(XMPDM.class, fields);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExceptionInInitializerError(illegalAccessException);
        }
        _fields = fields;
    }

    private static class ExtractMetadataProcessCallable
    implements ProcessCallable<org.apache.tika.metadata.Metadata> {
        private static final long serialVersionUID = 1L;
        private final File _file;
        private final Parser _parser;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public org.apache.tika.metadata.Metadata call() throws ProcessException {
            Logger logger = Logger.getLogger("org.apache.tika.parser.SQLite3Parser");
            logger.setLevel(Level.SEVERE);
            logger = Logger.getLogger("org.apache.tika.parsers.PDFParser");
            logger.setLevel(Level.SEVERE);
            try (FileInputStream inputStream = new FileInputStream(this._file);){
                org.apache.tika.metadata.Metadata metadata = ExtractMetadataProcessCallable._extractMetadata(inputStream, this._parser);
                return metadata;
            }
            catch (IOException ioException) {
                throw new ProcessException((Throwable)ioException);
            }
        }

        private static org.apache.tika.metadata.Metadata _extractMetadata(InputStream inputStream, Parser parser) throws IOException {
            org.apache.tika.metadata.Metadata metadata = new org.apache.tika.metadata.Metadata();
            ParseContext parseContext = new ParseContext();
            parseContext.set(Parser.class, (Object)parser);
            try {
                parser.parse(inputStream, (ContentHandler)new DefaultHandler(), metadata, parseContext);
            }
            catch (TikaException | SAXException exception) {
                throw new IOException(exception);
            }
            metadata.remove(XMPDM.ABS_PEAK_AUDIO_FILE_PATH.getName());
            metadata.remove(XMPDM.RELATIVE_PEAK_AUDIO_FILE_PATH.getName());
            return metadata;
        }

        private ExtractMetadataProcessCallable(File file, Parser parser) {
            this._file = file;
            this._parser = parser;
        }
    }
}

