/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.bundle.support.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.liferay.portal.tools.bundle.support.commands.Command;
import com.liferay.portal.tools.bundle.support.constants.BundleSupportConstants;
import com.liferay.portal.tools.bundle.support.internal.util.FileUtil;
import com.liferay.portal.tools.bundle.support.internal.util.HttpUtil;
import java.io.Console;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@Parameters(commandDescription="Create a liferay.com download token.", commandNames={"createToken"})
public class CreateTokenCommand
implements Command {
    private static final URL _DEFAULT_TOKEN_URL;
    @Parameter(description="Your liferay.com email address.", names={"-e", "--email"})
    private String _emailAddress;
    @Parameter(description="Force creation of liferay.com download token.", names={"-f", "--force"})
    private boolean _force;
    @Parameter(description="Your liferay.com password.", names={"-p", "--password"})
    private String _password;
    @Parameter(description="The file where to read the password value.", names={"--password-file"})
    private File _passwordFile;
    @Parameter(description="The file where to store your liferay.com download token.", names={"--token-file"})
    private File _tokenFile = BundleSupportConstants.DEFAULT_TOKEN_FILE;
    private URL _tokenURL = _DEFAULT_TOKEN_URL;

    @Override
    public void execute() throws Exception {
        if (this._tokenFile.exists() && !this.isForce()) {
            System.out.println("The liferay.com download token already exists.");
            return;
        }
        Console console = System.console();
        while (this._emailAddress == null || this._emailAddress.isEmpty()) {
            this._emailAddress = console.readLine("Email Address: ", new Object[0]);
        }
        if (this._passwordFile != null && this._passwordFile.exists()) {
            this._password = FileUtil.read(this._passwordFile);
        } else {
            while (this._password == null || this._password.isEmpty()) {
                char[] characters = console.readPassword("Password: ", new Object[0]);
                if (characters == null) continue;
                this._password = new String(characters);
            }
        }
        String token = HttpUtil.createToken(this._tokenURL.toURI(), this._emailAddress, this._password);
        Path tokenPath = this._tokenFile.toPath();
        Path dirPath = tokenPath.getParent();
        if (dirPath != null) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        Files.write(tokenPath, token.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public String getEmailAddress() {
        return this._emailAddress;
    }

    public String getPassword() {
        return this._password;
    }

    public File getPasswordFile() {
        return this._passwordFile;
    }

    public File getTokenFile() {
        return this._tokenFile;
    }

    public URL getTokenUrl() {
        return this._tokenURL;
    }

    public boolean isForce() {
        return this._force;
    }

    public void setEmailAddress(String emailAddress) {
        this._emailAddress = emailAddress;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setPasswordFile(File passwordFile) {
        this._passwordFile = passwordFile;
    }

    public void setTokenFile(File tokenFile) {
        this._tokenFile = tokenFile;
    }

    public void setTokenUrl(URL tokenURL) {
        this._tokenURL = tokenURL;
    }

    static {
        try {
            _DEFAULT_TOKEN_URL = new URL("https://web.liferay.com/token-auth-portlet/api/secure/jsonws/tokenauthentry/add-token-auth-entry");
        }
        catch (MalformedURLException malformedURLException) {
            throw new ExceptionInInitializerError(malformedURLException);
        }
    }
}

