/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.support;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.liferay.portal.tools.db.support.DBSupportArgs;
import com.liferay.portal.tools.db.support.commands.Command;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class DBSupport {
    public static void main(String[] args) throws Exception {
        DBSupportArgs dbSupportArgs = new DBSupportArgs();
        JCommander jCommander = new JCommander(dbSupportArgs);
        for (Command command : ServiceLoader.load(Command.class)) {
            jCommander.addCommand(command);
        }
        File jarFile = DBSupport._getJarFile();
        if (jarFile.isFile()) {
            jCommander.setProgramName("java -jar " + jarFile.getName());
        } else {
            jCommander.setProgramName(DBSupport.class.getName());
        }
        try {
            jCommander.parse(args);
            String commandName = jCommander.getParsedCommand();
            if (dbSupportArgs.isHelp() || commandName == null) {
                DBSupport._printHelp(jCommander);
            } else {
                Map<String, JCommander> commandJCommanders = jCommander.getCommands();
                JCommander commandJCommander = commandJCommanders.get(commandName);
                List<Object> commandObjects = commandJCommander.getObjects();
                Command command = (Command)commandObjects.get(0);
                command.execute(dbSupportArgs);
            }
        }
        catch (ParameterException parameterException) {
            if (!dbSupportArgs.isHelp()) {
                System.err.println(parameterException.getMessage());
            }
            DBSupport._printHelp(jCommander);
        }
    }

    private static File _getJarFile() throws Exception {
        ProtectionDomain protectionDomain = DBSupport.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        return new File(url.toURI());
    }

    private static void _printHelp(JCommander jCommander) {
        String commandName = jCommander.getParsedCommand();
        if (commandName == null) {
            jCommander.usage();
        } else {
            jCommander.usage(commandName);
        }
    }
}

