/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.support;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;

public class DBSupportArgs {
    private final Properties _cachedProperties = new Properties();
    private File _cachedPropertiesFile;
    @Parameter(description="Print this message.", help=true, names={"-h", "--help"})
    private boolean _help;
    @Parameter(description="The user password for connecting to the Liferay database.", names={"-p", "--password"}, password=true)
    private String _password;
    @Parameter(converter=FileConverter.class, description="The portal-ext.properties file which contains the JDBC settings for connecting to the Liferay database.", names={"-f", "--properties-file"})
    private File _propertiesFile;
    @Parameter(description="The JDBC URL for connecting to the Liferay database.", names={"-u", "--url"})
    private String _url;
    @Parameter(description="The user name for connecting to the Liferay database.", names={"-s", "--user-name"})
    private String _userName;

    public String getPassword() throws IOException {
        Properties properties = this._readProperties();
        return properties.getProperty("jdbc.default.password", this._password);
    }

    public File getPropertiesFile() {
        return this._propertiesFile;
    }

    public String getUrl() throws IOException {
        Properties properties = this._readProperties();
        return properties.getProperty("jdbc.default.url", this._url);
    }

    public String getUserName() throws IOException {
        Properties properties = this._readProperties();
        return properties.getProperty("jdbc.default.username", this._userName);
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setPropertiesFile(File propertiesFile) throws IOException {
        this._propertiesFile = propertiesFile;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    protected boolean isHelp() {
        return this._help;
    }

    private Properties _readProperties() throws IOException {
        if (Objects.equals(this._cachedPropertiesFile, this._propertiesFile)) {
            return this._cachedProperties;
        }
        this._cachedProperties.clear();
        if (this._propertiesFile != null) {
            try (FileInputStream fileInputStream = new FileInputStream(this._propertiesFile);){
                this._cachedProperties.load(fileInputStream);
            }
        }
        this._cachedPropertiesFile = this._propertiesFile;
        return this._cachedProperties;
    }
}

