/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.java.parser.BaseJavaLoopStatement;
import com.liferay.portal.tools.java.parser.JavaExpression;
import com.liferay.portal.tools.java.parser.JavaTerm;
import com.liferay.portal.tools.java.parser.JavaVariableDefinition;
import java.util.List;

public class JavaForStatement
extends BaseJavaLoopStatement {
    private JavaExpression _conditionJavaExpression;
    private List<JavaTerm> _initializationJavaTerms;
    private List<JavaExpression> _iteratorJavaExpressions;

    public void setConditionJavaExpression(JavaExpression conditionJavaExpression) {
        this._conditionJavaExpression = conditionJavaExpression;
    }

    public void setInitializationJavaTerms(List<JavaTerm> initializationJavaTerms) {
        this._initializationJavaTerms = initializationJavaTerms;
    }

    public void setIteratorJavaExpression(List<JavaExpression> iteratorJavaExpressions) {
        this._iteratorJavaExpressions = iteratorJavaExpressions;
    }

    @Override
    public String toString(String indent, String prefix, String suffix, int maxLineLength) {
        StringBundler sb = this.appendLabelName(indent);
        if (sb.index() > 0) {
            sb.append("\n");
        }
        sb.append(indent);
        indent = "\t" + indent;
        if (this._conditionJavaExpression == null && this._initializationJavaTerms.isEmpty() && this._iteratorJavaExpressions.isEmpty()) {
            sb.append(prefix);
            sb.append("for (;;)");
            sb.append(suffix);
            return sb.toString();
        }
        if (this._initializationJavaTerms.size() == 1) {
            this.append(sb, this._initializationJavaTerms.get(0), indent, prefix + "for (", this._getInitializationJavaTermsSuffix(suffix), maxLineLength);
        } else {
            String javaTermSuffix = ", ";
            for (int i = 0; i < this._initializationJavaTerms.size(); ++i) {
                JavaTerm javaTerm = this._initializationJavaTerms.get(i);
                if (i == 0) {
                    this.append(sb, javaTerm, indent, prefix + "for (", javaTermSuffix, maxLineLength);
                    continue;
                }
                if (i == this._initializationJavaTerms.size() - 1) {
                    javaTermSuffix = this._getInitializationJavaTermsSuffix(suffix);
                }
                if (javaTerm instanceof JavaVariableDefinition) {
                    JavaVariableDefinition javaVariableDefinition = (JavaVariableDefinition)javaTerm;
                    javaVariableDefinition.setJavaType(null);
                    this.append(sb, javaVariableDefinition, indent, "", javaTermSuffix, maxLineLength);
                    continue;
                }
                this.append(sb, javaTerm, indent, "", javaTermSuffix, maxLineLength);
            }
        }
        indent = indent + " ";
        if (this._conditionJavaExpression != null) {
            String conditionJavaExpressionSuffix = this._getConditionJavaExpressionSuffix(suffix);
            if (this._initializationJavaTerms.isEmpty()) {
                if (!this.appendSingleLine(sb, this._conditionJavaExpression, prefix + "for (; ", conditionJavaExpressionSuffix, maxLineLength)) {
                    sb.append(prefix);
                    sb.append("for (;\n");
                    this.appendNewLine(sb, this._conditionJavaExpression, indent, "", StringUtil.trimTrailing((String)conditionJavaExpressionSuffix), maxLineLength);
                    sb.append("\n");
                    sb.append(indent);
                }
            } else if (this.getLineLength(this.getIndent(this.getLastLine(sb))) > this.getLineLength(indent)) {
                this.appendNewLine(sb, this._conditionJavaExpression, indent, "", conditionJavaExpressionSuffix, maxLineLength);
            } else {
                this.append(sb, this._conditionJavaExpression, indent, "", conditionJavaExpressionSuffix, maxLineLength);
            }
        }
        if (!this._iteratorJavaExpressions.isEmpty()) {
            if (this.getLineLength(this.getIndent(this.getLastLine(sb))) > this.getLineLength(indent)) {
                this.appendNewLine(sb, this._iteratorJavaExpressions, indent, this._getIteratorJavaExpressionsPrefix(prefix), ")" + suffix, maxLineLength);
            } else {
                this.append(sb, this._iteratorJavaExpressions, indent, this._getIteratorJavaExpressionsPrefix(prefix), ")" + suffix, maxLineLength);
            }
        }
        return sb.toString();
    }

    private String _getConditionJavaExpressionSuffix(String suffix) {
        if (!this._iteratorJavaExpressions.isEmpty()) {
            return "; ";
        }
        return ";)" + suffix;
    }

    private String _getInitializationJavaTermsSuffix(String suffix) {
        if (this._conditionJavaExpression != null) {
            return "; ";
        }
        if (!this._iteratorJavaExpressions.isEmpty()) {
            return ";; ";
        }
        return ";;)" + suffix;
    }

    private String _getIteratorJavaExpressionsPrefix(String prefix) {
        if (!this._initializationJavaTerms.isEmpty() || this._conditionJavaExpression != null) {
            return "";
        }
        return prefix + "for (;; ";
    }
}

